/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.util.Iterator;
import org.moeaframework.core.Population;
import org.moeaframework.core.Settings;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;

public class NondominatedPopulation
extends Population {
    protected final DominanceComparator comparator;
    protected final DuplicateMode duplicateMode;

    public NondominatedPopulation() {
        this(new ParetoDominanceComparator());
    }

    public NondominatedPopulation(DuplicateMode duplicateMode) {
        this((DominanceComparator)new ParetoDominanceComparator(), duplicateMode);
    }

    public NondominatedPopulation(DominanceComparator comparator) {
        this(comparator, Settings.getDuplicateMode());
    }

    @Deprecated
    public NondominatedPopulation(DominanceComparator comparator, boolean allowDuplicates) {
        this(comparator, allowDuplicates ? DuplicateMode.ALLOW_DUPLICATES : DuplicateMode.NO_DUPLICATE_OBJECTIVES);
    }

    public NondominatedPopulation(DominanceComparator comparator, DuplicateMode duplicateMode) {
        this.comparator = comparator;
        this.duplicateMode = duplicateMode;
    }

    public NondominatedPopulation(Iterable<? extends Solution> iterable) {
        this();
        this.addAll(iterable);
    }

    public NondominatedPopulation(DominanceComparator comparator, Iterable<? extends Solution> iterable) {
        this(comparator);
        this.addAll(iterable);
    }

    @Override
    public boolean add(Solution newSolution) {
        Iterator<Solution> iterator = this.iterator();
        while (iterator.hasNext()) {
            Solution oldSolution = iterator.next();
            int flag = this.comparator.compare(newSolution, oldSolution);
            if (flag < 0) {
                iterator.remove();
                continue;
            }
            if (flag > 0) {
                return false;
            }
            if (!this.isDuplicate(newSolution, oldSolution)) continue;
            return false;
        }
        return super.add(newSolution);
    }

    @Override
    public void replace(int index, Solution newSolution) {
        Iterator<Solution> iterator = this.iterator();
        while (iterator.hasNext()) {
            Solution oldSolution = iterator.next();
            int flag = this.comparator.compare(newSolution, oldSolution);
            if (flag < 0) {
                iterator.remove();
                continue;
            }
            if (flag > 0) {
                return;
            }
            if (!this.isDuplicate(newSolution, oldSolution)) continue;
            return;
        }
        super.replace(index, newSolution);
    }

    protected boolean forceAddWithoutCheck(Solution newSolution) {
        return super.add(newSolution);
    }

    protected static double distance(Solution s1, Solution s2) {
        double distance = 0.0;
        for (int i = 0; i < s1.getNumberOfObjectives(); ++i) {
            distance += Math.pow(s1.getObjective(i) - s2.getObjective(i), 2.0);
        }
        return Math.sqrt(distance);
    }

    protected boolean isDuplicate(Solution s1, Solution s2) {
        switch (this.duplicateMode) {
            case NO_DUPLICATE_OBJECTIVES: {
                return NondominatedPopulation.distance(s1, s2) < 1.0E-10;
            }
            case ALLOW_DUPLICATE_OBJECTIVES: {
                if (s1.getNumberOfVariables() != s2.getNumberOfVariables()) {
                    return false;
                }
                for (int i = 0; i < s1.getNumberOfVariables(); ++i) {
                    if (s1.getVariable(i).equals(s2.getVariable(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public DominanceComparator getComparator() {
        return this.comparator;
    }

    public static enum DuplicateMode {
        NO_DUPLICATE_OBJECTIVES,
        ALLOW_DUPLICATE_OBJECTIVES,
        ALLOW_DUPLICATES;

    }
}

