/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.util.ArrayList;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.ObjectiveComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;

public class NondominatedSorting {
    public static final String RANK_ATTRIBUTE = "rank";
    public static final String CROWDING_ATTRIBUTE = "crowdingDistance";
    protected final DominanceComparator comparator;

    public NondominatedSorting() {
        this(new ParetoDominanceComparator());
    }

    public NondominatedSorting(DominanceComparator comparator) {
        this.comparator = comparator;
    }

    public DominanceComparator getComparator() {
        return this.comparator;
    }

    public void evaluate(Population population) {
        ArrayList<Solution> remaining = new ArrayList<Solution>();
        for (Solution solution : population) {
            remaining.add(solution);
        }
        int rank = 0;
        while (!remaining.isEmpty()) {
            NondominatedPopulation front = new NondominatedPopulation(this.comparator, NondominatedPopulation.DuplicateMode.ALLOW_DUPLICATES);
            for (Solution solution : remaining) {
                front.add(solution);
            }
            for (Solution solution : front) {
                remaining.remove(solution);
                solution.setAttribute(RANK_ATTRIBUTE, Integer.valueOf(rank));
            }
            this.updateCrowdingDistance(front);
            ++rank;
        }
    }

    public void updateCrowdingDistance(Population front) {
        for (Solution solution : front) {
            solution.setAttribute(CROWDING_ATTRIBUTE, Double.valueOf(0.0));
        }
        Population uniqueFront = new Population();
        for (Solution s1 : front) {
            boolean isDuplicate = false;
            for (Solution s2 : uniqueFront) {
                if (!(NondominatedPopulation.distance(s1, s2) < 1.0E-10)) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate) continue;
            uniqueFront.add(s1);
        }
        front = uniqueFront;
        int n = front.size();
        if (n < 3) {
            for (Solution solution : front) {
                solution.setAttribute(CROWDING_ATTRIBUTE, Double.valueOf(Double.POSITIVE_INFINITY));
            }
        } else {
            int numberOfObjectives = front.get(0).getNumberOfObjectives();
            for (int i = 0; i < numberOfObjectives; ++i) {
                front.sort(new ObjectiveComparator(i));
                double minObjective = front.get(0).getObjective(i);
                double maxObjective = front.get(n - 1).getObjective(i);
                front.get(0).setAttribute(CROWDING_ATTRIBUTE, Double.valueOf(Double.POSITIVE_INFINITY));
                front.get(n - 1).setAttribute(CROWDING_ATTRIBUTE, Double.valueOf(Double.POSITIVE_INFINITY));
                for (int j = 1; j < n - 1; ++j) {
                    double distance = (Double)front.get(j).getAttribute(CROWDING_ATTRIBUTE);
                    front.get(j).setAttribute(CROWDING_ATTRIBUTE, Double.valueOf(distance += (front.get(j + 1).getObjective(i) - front.get(j - 1).getObjective(i)) / (maxObjective - minObjective)));
                }
            }
        }
    }
}

