/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.util.Comparator;
import java.util.Iterator;
import org.moeaframework.core.FastNondominatedSorting;
import org.moeaframework.core.NondominatedSorting;
import org.moeaframework.core.Population;
import org.moeaframework.core.Settings;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.CrowdingComparator;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.NondominatedSortingComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.comparator.RankComparator;

public class NondominatedSortingPopulation
extends Population {
    private boolean modified = false;
    private final NondominatedSorting nondominatedSorting;

    public NondominatedSortingPopulation() {
        this(new ParetoDominanceComparator());
    }

    public NondominatedSortingPopulation(DominanceComparator comparator) {
        this.nondominatedSorting = Settings.useFastNondominatedSorting() ? new FastNondominatedSorting(comparator) : new NondominatedSorting(comparator);
    }

    public NondominatedSortingPopulation(DominanceComparator comparator, Iterable<? extends Solution> iterable) {
        this(comparator);
        this.addAll(iterable);
    }

    public NondominatedSortingPopulation(Iterable<? extends Solution> iterable) {
        this(new ParetoDominanceComparator(), iterable);
    }

    @Override
    public boolean add(Solution solution) {
        this.modified = true;
        return super.add(solution);
    }

    @Override
    public void replace(int index, Solution solution) {
        this.modified = true;
        super.replace(index, solution);
    }

    @Override
    public Solution get(int index) {
        if (this.modified) {
            this.update();
        }
        return super.get(index);
    }

    @Override
    public void remove(int index) {
        this.modified = true;
        super.remove(index);
    }

    @Override
    public boolean remove(Solution solution) {
        this.modified = true;
        return super.remove(solution);
    }

    @Override
    public void clear() {
        this.modified = true;
        super.clear();
    }

    @Override
    public Iterator<Solution> iterator() {
        if (this.modified) {
            this.update();
        }
        return super.iterator();
    }

    @Override
    public void sort(Comparator<? super Solution> comparator) {
        if (this.modified) {
            this.update();
        }
        super.sort(comparator);
    }

    @Override
    public void truncate(int size, Comparator<? super Solution> comparator) {
        if (this.modified) {
            this.update();
        }
        super.truncate(size, comparator);
    }

    public void truncate(int size) {
        this.truncate(size, new NondominatedSortingComparator());
    }

    public void prune(int size) {
        if (this.modified) {
            this.update();
        }
        this.sort(new RankComparator());
        int maxRank = (Integer)super.get(size - 1).getAttribute("rank");
        Population front = new Population();
        for (int i = this.size() - 1; i >= 0; --i) {
            Solution solution = super.get(i);
            int rank = (Integer)solution.getAttribute("rank");
            if (rank < maxRank) continue;
            super.remove(i);
            if (rank != maxRank) continue;
            front.add(solution);
        }
        while (this.size() + front.size() > size) {
            this.nondominatedSorting.updateCrowdingDistance(front);
            front.truncate(front.size() - 1, new CrowdingComparator());
        }
        this.addAll(front);
    }

    public void update() {
        this.modified = false;
        this.nondominatedSorting.evaluate(this);
    }
}

