/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomAdaptor;
import org.apache.commons.math3.random.RandomGenerator;

public class PRNG {
    private static Random random = new RandomAdaptor((RandomGenerator)new MersenneTwister());

    private PRNG() {
    }

    public static synchronized void setSeed(long seed) {
        random.setSeed(seed);
    }

    public static synchronized void setRandom(Random random) {
        PRNG.random = random;
    }

    public static Random getRandom() {
        return random;
    }

    public static float nextFloat() {
        return random.nextFloat();
    }

    public static float nextFloat(float min, float max) {
        return min + random.nextFloat() * (max - min);
    }

    public static double nextDouble() {
        return random.nextDouble();
    }

    public static double nextDouble(double min, double max) {
        return min + random.nextDouble() * (max - min);
    }

    public static int nextInt() {
        return random.nextInt();
    }

    public static int nextInt(int n) {
        return random.nextInt(n);
    }

    public static int nextInt(int min, int max) {
        return min + random.nextInt(max - min + 1);
    }

    public static boolean nextBoolean() {
        return random.nextBoolean();
    }

    public static double nextGaussian() {
        return random.nextGaussian();
    }

    public static double nextGaussian(double mean, double stdev) {
        return stdev * random.nextGaussian() + mean;
    }

    public static <T> void shuffle(T[] array) {
        for (int i = array.length - 1; i >= 1; --i) {
            int j = PRNG.nextInt(i + 1);
            if (i == j) continue;
            T temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static void shuffle(double[] array) {
        for (int i = array.length - 1; i >= 1; --i) {
            int j = PRNG.nextInt(i + 1);
            if (i == j) continue;
            double temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static void shuffle(float[] array) {
        for (int i = array.length - 1; i >= 1; --i) {
            int j = PRNG.nextInt(i + 1);
            if (i == j) continue;
            float temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static void shuffle(long[] array) {
        for (int i = array.length - 1; i >= 1; --i) {
            int j = PRNG.nextInt(i + 1);
            if (i == j) continue;
            long temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static void shuffle(int[] array) {
        for (int i = array.length - 1; i >= 1; --i) {
            int j = PRNG.nextInt(i + 1);
            if (i == j) continue;
            int temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static void shuffle(short[] array) {
        for (int i = array.length - 1; i >= 1; --i) {
            int j = PRNG.nextInt(i + 1);
            if (i == j) continue;
            short temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static void shuffle(byte[] array) {
        for (int i = array.length - 1; i >= 1; --i) {
            int j = PRNG.nextInt(i + 1);
            if (i == j) continue;
            byte temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static void shuffle(boolean[] array) {
        for (int i = array.length - 1; i >= 1; --i) {
            int j = PRNG.nextInt(i + 1);
            if (i == j) continue;
            boolean temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
    }

    public static <T> void shuffle(List<T> list) {
        Collections.shuffle(list, random);
    }

    public static <T> T nextItem(List<T> list) {
        return list.get(PRNG.nextInt(list.size()));
    }
}

