/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.moeaframework.core.Solution;

public class Population
implements Iterable<Solution> {
    private final List<Solution> data = new ArrayList<Solution>();
    private int modCount;

    public Population() {
    }

    public Population(Iterable<? extends Solution> iterable) {
        this();
        this.addAll(iterable);
    }

    public <T extends Solution> Population(T[] solutions) {
        this(Arrays.asList(solutions));
    }

    public Solution get(int index) {
        return this.data.get(index);
    }

    public void remove(int index) {
        ++this.modCount;
        this.data.remove(index);
    }

    public int indexOf(Solution solution) {
        return this.data.indexOf(solution);
    }

    public boolean add(Solution solution) {
        return this.data.add(solution);
    }

    public boolean addAll(Iterable<? extends Solution> iterable) {
        boolean changed = false;
        for (Solution solution : iterable) {
            changed |= this.add(solution);
        }
        return changed;
    }

    public <T extends Solution> boolean addAll(T[] solutions) {
        return this.addAll(Arrays.asList(solutions));
    }

    public void replace(int index, Solution solution) {
        this.data.set(index, solution);
    }

    public void clear() {
        ++this.modCount;
        this.data.clear();
    }

    public boolean contains(Solution solution) {
        return this.data.contains(solution);
    }

    public boolean containsAll(Iterable<? extends Solution> iterable) {
        boolean missing = false;
        for (Solution solution : iterable) {
            missing |= !this.contains(solution);
        }
        return !missing;
    }

    public <T extends Solution> boolean containsAll(T[] solutions) {
        return this.containsAll(Arrays.asList(solutions));
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public Iterator<Solution> iterator() {
        return new PopulationIterator();
    }

    public boolean remove(Solution solution) {
        ++this.modCount;
        return this.data.remove(solution);
    }

    public boolean removeAll(Iterable<? extends Solution> iterable) {
        boolean changed = false;
        for (Solution solution : iterable) {
            changed |= this.remove(solution);
        }
        return changed;
    }

    public <T extends Solution> boolean removeAll(T[] solutions) {
        return this.removeAll(Arrays.asList(solutions));
    }

    public int size() {
        return this.data.size();
    }

    public void sort(Comparator<? super Solution> comparator) {
        Collections.sort(this.data, comparator);
    }

    public void truncate(int size, Comparator<? super Solution> comparator) {
        this.sort(comparator);
        while (this.data.size() > size) {
            this.data.remove(this.data.size() - 1);
        }
    }

    private class PopulationIterator
    implements Iterator<Solution> {
        private int nextIndex = 0;
        private int currentIndex = -1;
        private int expectedModCount;

        public PopulationIterator() {
            this.expectedModCount = Population.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != Population.this.size();
        }

        @Override
        public Solution next() {
            this.checkModCount();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Solution value = Population.this.get(this.nextIndex);
                this.currentIndex = this.nextIndex++;
                return value;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            this.checkModCount();
            if (this.currentIndex == -1) {
                throw new IllegalStateException();
            }
            try {
                Population.this.remove(this.currentIndex);
                --this.nextIndex;
                this.currentIndex = -1;
                ++this.expectedModCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkModCount() {
            if (Population.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

