/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.moeaframework.core.Population;
import org.moeaframework.core.Solution;
import org.moeaframework.util.io.CommentedLineReader;

public class PopulationIO {
    private PopulationIO() {
    }

    public static Population readObjectives(BufferedReader reader) throws IOException {
        Population population = new Population();
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.trim().split("\\s+");
            double[] values = new double[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                values[i] = Double.parseDouble(tokens[i]);
            }
            population.add(new Solution(values));
        }
        return population;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Population readObjectives(File file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new CommentedLineReader(new FileReader(file));
            Population population = PopulationIO.readObjectives(reader);
            return population;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectives(File file, Iterable<Solution> solutions) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            for (Solution solution : solutions) {
                writer.write(Double.toString(solution.getObjective(0)));
                for (int i = 1; i < solution.getNumberOfObjectives(); ++i) {
                    writer.write(" ");
                    writer.write(Double.toString(solution.getObjective(i)));
                }
                writer.newLine();
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, Iterable<Solution> solutions) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            ArrayList<Solution> list = new ArrayList<Solution>();
            for (Solution solution : solutions) {
                list.add(solution);
            }
            oos.writeObject(list);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    public static Population read(File file) throws IOException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            Population population = new Population();
            for (Object solution : (List)ois.readObject()) {
                population.add((Solution)solution);
            }
            Population population2 = population;
            return population2;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }
}

