/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.text.StrTokenizer;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.util.TypedProperties;

public class Settings {
    public static final double EPS = 1.0E-10;
    public static final int BUFFER_SIZE = 4096;
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final TypedProperties PROPERTIES;
    public static final String KEY_PREFIX = "org.moeaframework.";
    public static final String KEY_DUPLICATE_MODE = "org.moeaframework.core.duplicate_mode";
    public static final String KEY_GD_POWER = "org.moeaframework.core.indicator.gd_power";
    public static final String KEY_IGD_POWER = "org.moeaframework.core.indicator.igd_power";
    public static final String KEY_FAST_NONDOMINATED_SORTING = "org.moeaframework.core.fast_nondominated_sorting";
    public static final String KEY_CONTINUITY_CORRECTION = "org.moeaframework.util.statistics.continuity_correction";
    public static final String KEY_HYPERVOLUME_DELTA = "org.moeaframework.core.indicator.hypervolume_delta";
    public static final String KEY_IDEALPT_PREFIX = "org.moeaframework.core.indicator.hypervolume_idealpt.";
    public static final String KEY_REFPT_PREFIX = "org.moeaframework.core.indicator.hypervolume_refpt.";
    public static final String KEY_HYPERVOLUME = "org.moeaframework.core.indicator.hypervolume";
    public static final String KEY_HYPERVOLUME_INVERTED = "org.moeaframework.core.indicator.hypervolume_inverted";
    public static final String KEY_HYPERVOLUME_ENABLED = "org.moeaframework.core.indicator.hypervolume_enabled";
    public static final String KEY_PROBLEM_PREFIX = "org.moeaframework.problem.";
    public static final String KEY_PROBLEM_LIST = "org.moeaframework.problem.problems";
    public static final String KEY_PISA_PREFIX = "org.moeaframework.algorithm.pisa.";
    public static final String KEY_PISA_ALGORITHMS = "org.moeaframework.algorithm.pisa.algorithms";
    public static final String KEY_PISA_POLL = "org.moeaframework.algorithm.pisa.poll";
    public static final String KEY_FILE_PROTECTION_MODE = "org.moeaframework.util.io.file_protection_mode";
    public static final String KEY_FILE_PROTECTION_FORMAT = "org.moeaframework.util.io.file_protection_format";
    public static final String KEY_DIAGNOSTIC_TOOL_ALGORITHMS = "org.moeaframework.analysis.diagnostics.algorithms";
    public static final String KEY_DIAGNOSTIC_TOOL_PROBLEMS = "org.moeaframework.analysis.diagnostics.problems";
    public static final String KEY_GP_PROTECTED_FUNCTIONS = "org.moeaframework.util.tree.protected_functions";
    public static final String KEY_CLEANUP_STRATEGY = "org.moeaframework.analysis.sensitivity.cleanup";
    @Deprecated
    public static final String KEY_ALLOWED_PACKAGES = "org.moeaframework.allowed_packages";

    private Settings() {
    }

    public static boolean isContinuityCorrection() {
        return PROPERTIES.getBoolean(KEY_CONTINUITY_CORRECTION, false);
    }

    public static NondominatedPopulation.DuplicateMode getDuplicateMode() {
        return NondominatedPopulation.DuplicateMode.valueOf(PROPERTIES.getString(KEY_DUPLICATE_MODE, NondominatedPopulation.DuplicateMode.NO_DUPLICATE_OBJECTIVES.name()).toUpperCase());
    }

    public static double getGDPower() {
        return PROPERTIES.getDouble(KEY_GD_POWER, 2.0);
    }

    public static double getIGDPower() {
        return PROPERTIES.getDouble(KEY_IGD_POWER, 1.0);
    }

    public static double[] getIdealPoint(String problem) {
        return PROPERTIES.getDoubleArray(KEY_IDEALPT_PREFIX + problem, null);
    }

    public static double[] getReferencePoint(String problem) {
        return PROPERTIES.getDoubleArray(KEY_REFPT_PREFIX + problem, null);
    }

    public static boolean useFastNondominatedSorting() {
        return PROPERTIES.getBoolean(KEY_FAST_NONDOMINATED_SORTING, false);
    }

    public static double getHypervolumeDelta() {
        return PROPERTIES.getDouble(KEY_HYPERVOLUME_DELTA, 0.0);
    }

    public static String getHypervolume() {
        return PROPERTIES.getString(KEY_HYPERVOLUME, null);
    }

    public static boolean isHypervolumeInverted() {
        return PROPERTIES.getBoolean(KEY_HYPERVOLUME_INVERTED, false);
    }

    public static boolean isHypervolumeEnabled() {
        return PROPERTIES.getBoolean(KEY_HYPERVOLUME_ENABLED, true);
    }

    public static String[] getProblems() {
        return PROPERTIES.getStringArray(KEY_PROBLEM_LIST, new String[0]);
    }

    public static String getProblemClass(String name) {
        return PROPERTIES.getString(KEY_PROBLEM_PREFIX + name + ".class", null);
    }

    public static String getProblemReferenceSet(String name) {
        return PROPERTIES.getString(KEY_PROBLEM_PREFIX + name + ".referenceSet", null);
    }

    public static String[] getPISAAlgorithms() {
        return PROPERTIES.getStringArray(KEY_PISA_ALGORITHMS, new String[0]);
    }

    public static int getPISAPollRate() {
        return PROPERTIES.getInt(KEY_PISA_POLL, 100);
    }

    public static String getPISACommand(String algorithmName) {
        return PROPERTIES.getString(KEY_PISA_PREFIX + algorithmName + ".command", null);
    }

    public static String getPISAConfiguration(String algorithmName) {
        return PROPERTIES.getString(KEY_PISA_PREFIX + algorithmName + ".configuration", null);
    }

    public static String[] getPISAParameters(String algorithmName) {
        return PROPERTIES.getStringArray(KEY_PISA_PREFIX + algorithmName + ".parameters", new String[0]);
    }

    public static String getPISAParameterDefaultValue(String algorithmName, String parameterName) {
        return PROPERTIES.getString(KEY_PISA_PREFIX + algorithmName + ".parameter." + parameterName, null);
    }

    public static String getFileProtectionMode() {
        return PROPERTIES.getString(KEY_FILE_PROTECTION_MODE, "SAFE");
    }

    public static String getFileProtectionFormat() {
        return PROPERTIES.getString(KEY_FILE_PROTECTION_FORMAT, ".{0}.md5");
    }

    public static String[] getDiagnosticToolAlgorithms() {
        return PROPERTIES.getStringArray(KEY_DIAGNOSTIC_TOOL_ALGORITHMS, new String[]{"NSGAII", "NSGAIII", "GDE3", "eMOEA", "eNSGAII", "MOEAD", "CMA-ES", "SPEA2", "PAES", "PESA2", "OMOPSO", "SMPSO", "IBEA", "SMS-EMOA", "VEGA", "DBEA", "Random", "RVEA"});
    }

    public static String[] getDiagnosticToolProblems() {
        return PROPERTIES.getStringArray(KEY_DIAGNOSTIC_TOOL_PROBLEMS, new String[]{"DTLZ1_2", "DTLZ2_2", "DTLZ3_2", "DTLZ4_2", "DTLZ7_2", "ROT_DTLZ1_2", "ROT_DTLZ2_2", "ROT_DTLZ3_2", "ROT_DTLZ4_2", "ROT_DTLZ7_2", "UF1", "UF2", "UF3", "UF4", "UF5", "UF6", "UF7", "UF8", "UF9", "UF10", "UF11", "UF12", "UF13", "CF1", "CF2", "CF3", "CF4", "CF5", "CF6", "CF7", "CF8", "CF9", "CF10", "LZ1", "LZ2", "LZ3", "LZ4", "LZ5", "LZ6", "LZ7", "LZ8", "LZ9", "WFG1_2", "WFG2_2", "WFG3_2", "WFG4_2", "WFG5_2", "WFG6_2", "WFG7_2", "WFG8_2", "WFG9_2", "ZDT1", "ZDT2", "ZDT3", "ZDT4", "ZDT5", "ZDT6", "Belegundu", "Binh", "Binh2", "Binh3", "Binh4", "Fonseca", "Fonseca2", "Jimenez", "Kita", "Kursawe", "Laumanns", "Lis", "Murata", "Obayashi", "OKA1", "OKA2", "Osyczka", "Osyczka2", "Poloni", "Quagliarella", "Rendon", "Rendon2", "Schaffer", "Schaffer2", "Srinivas", "Tamaki", "Tanaka", "Viennet", "Viennet2", "Viennet3", "Viennet4"});
    }

    public static String[] parseCommand(String command) {
        return new StrTokenizer(command).setQuoteChar('\"').getTokenArray();
    }

    public static boolean isProtectedFunctions() {
        return PROPERTIES.getBoolean(KEY_GP_PROTECTED_FUNCTIONS, true);
    }

    public static String getCleanupStrategy() {
        return PROPERTIES.getString(KEY_CLEANUP_STRATEGY, "error");
    }

    @Deprecated
    public static String[] getAllowedPackages() {
        return PROPERTIES.getStringArray(KEY_ALLOWED_PACKAGES, new String[0]);
    }

    public static List<Image> getIconImages() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(toolkit.getImage(Settings.class.getResource("logo16.png")));
        icons.add(toolkit.getImage(Settings.class.getResource("logo24.png")));
        icons.add(toolkit.getImage(Settings.class.getResource("logo32.png")));
        icons.add(toolkit.getImage(Settings.class.getResource("logo48.png")));
        icons.add(toolkit.getImage(Settings.class.getResource("logo64.png")));
        icons.add(toolkit.getImage(Settings.class.getResource("logo128.png")));
        icons.add(toolkit.getImage(Settings.class.getResource("logo256.png")));
        return icons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String resource = "global.properties";
        Properties properties = null;
        try {
            properties = new Properties(System.getProperties());
            if (properties.containsKey("org.moeaframework.configuration")) {
                resource = properties.getProperty("org.moeaframework.configuration");
            }
        }
        catch (SecurityException e) {
            properties = new Properties();
        }
        try {
            File file = new File(resource);
            Reader reader = null;
            try {
                if (file.exists()) {
                    reader = new BufferedReader(new FileReader(file));
                } else {
                    InputStream stream = Settings.class.getResourceAsStream("/" + resource);
                    if (stream != null) {
                        reader = new BufferedReader(new InputStreamReader(stream));
                    }
                }
                if (reader != null) {
                    properties.load(reader);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new FrameworkException(e);
        }
        PROPERTIES = new TypedProperties(properties);
    }
}

