/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.moeaframework.core.Variable;

public class Solution
implements Serializable {
    private static final long serialVersionUID = -1192586435663892479L;
    private final Variable[] variables;
    private final double[] objectives;
    private final double[] constraints;
    private final Map<String, Serializable> attributes;

    public Solution(int numberOfVariables, int numberOfObjectives) {
        this(numberOfVariables, numberOfObjectives, 0);
    }

    public Solution(int numberOfVariables, int numberOfObjectives, int numberOfConstraints) {
        this.variables = new Variable[numberOfVariables];
        this.objectives = new double[numberOfObjectives];
        this.constraints = new double[numberOfConstraints];
        this.attributes = new HashMap<String, Serializable>();
    }

    public Solution(double[] objectives) {
        this(0, objectives.length, 0);
        for (int i = 0; i < objectives.length; ++i) {
            this.setObjective(i, objectives[i]);
        }
    }

    protected Solution(Solution solution) {
        this(solution.getNumberOfVariables(), solution.getNumberOfObjectives(), solution.getNumberOfConstraints());
        int i;
        for (i = 0; i < solution.getNumberOfVariables(); ++i) {
            this.setVariable(i, solution.getVariable(i).copy());
        }
        for (i = 0; i < this.getNumberOfObjectives(); ++i) {
            this.setObjective(i, solution.getObjective(i));
        }
        for (i = 0; i < this.getNumberOfConstraints(); ++i) {
            this.setConstraint(i, solution.getConstraint(i));
        }
    }

    public Solution copy() {
        return new Solution(this);
    }

    public Solution deepCopy() {
        Solution copy = this.copy();
        for (Map.Entry<String, Serializable> entry : this.getAttributes().entrySet()) {
            copy.setAttribute(entry.getKey(), SerializationUtils.clone((Serializable)entry.getValue()));
        }
        return copy;
    }

    public int getNumberOfObjectives() {
        return this.objectives.length;
    }

    public int getNumberOfVariables() {
        return this.variables.length;
    }

    public int getNumberOfConstraints() {
        return this.constraints.length;
    }

    public double getObjective(int index) {
        return this.objectives[index];
    }

    public Variable getVariable(int index) {
        return this.variables[index];
    }

    public void setObjective(int index, double objective) {
        this.objectives[index] = objective;
    }

    public void setObjectives(double[] objectives) {
        if (objectives.length != this.objectives.length) {
            throw new IllegalArgumentException("invalid number of objectives");
        }
        for (int i = 0; i < objectives.length; ++i) {
            this.objectives[i] = objectives[i];
        }
    }

    public double[] getObjectives() {
        return (double[])this.objectives.clone();
    }

    public void setVariable(int index, Variable variable) {
        this.variables[index] = variable;
    }

    public boolean violatesConstraints() {
        for (int i = 0; i < this.constraints.length; ++i) {
            if (this.constraints[i] == 0.0) continue;
            return true;
        }
        return false;
    }

    public double getConstraint(int index) {
        return this.constraints[index];
    }

    public void setConstraints(double[] constraints) {
        if (constraints.length != this.constraints.length) {
            throw new IllegalArgumentException("invalid number of constraints");
        }
        for (int i = 0; i < constraints.length; ++i) {
            this.constraints[i] = constraints[i];
        }
    }

    public double[] getConstraints() {
        return (double[])this.constraints.clone();
    }

    public void setConstraint(int index, double constraint) {
        this.constraints[index] = constraint;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Object setAttribute(String key, Serializable value) {
        return this.attributes.put(key, value);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public Map<String, Serializable> getAttributes() {
        return this.attributes;
    }

    public void addAttributes(Map<String, Object> attributes) {
        attributes.putAll(attributes);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }
}

