/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.comparator;

import java.io.Serializable;
import java.util.Comparator;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;

public class AggregateConstraintComparator
implements DominanceComparator,
Comparator<Solution>,
Serializable {
    private static final long serialVersionUID = 2876962422278502088L;

    protected double getConstraints(Solution solution) {
        double constraints = 0.0;
        for (int i = 0; i < solution.getNumberOfConstraints(); ++i) {
            constraints += Math.abs(solution.getConstraint(i));
        }
        return constraints;
    }

    @Override
    public int compare(Solution solution1, Solution solution2) {
        double constraints1 = this.getConstraints(solution1);
        double constraints2 = this.getConstraints(solution2);
        if (constraints1 != 0.0 || constraints2 != 0.0) {
            if (constraints1 == 0.0) {
                return -1;
            }
            if (constraints2 == 0.0) {
                return 1;
            }
            return Double.compare(constraints1, constraints2);
        }
        return 0;
    }
}

