/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.comparator;

import java.io.Serializable;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;

public class EpsilonBoxObjectiveComparator
implements DominanceComparator,
Serializable {
    private static final long serialVersionUID = -5454497496983459905L;
    protected boolean isSameBox;
    protected final double[] epsilons;

    public EpsilonBoxObjectiveComparator(double epsilon) {
        this.epsilons = new double[]{epsilon};
    }

    public EpsilonBoxObjectiveComparator(double[] epsilons) {
        this.epsilons = (double[])epsilons.clone();
    }

    public boolean isSameBox() {
        return this.isSameBox;
    }

    protected void setSameBox(boolean isSameBox) {
        this.isSameBox = isSameBox;
    }

    public double getEpsilon(int objective) {
        return this.epsilons[objective < this.epsilons.length ? objective : this.epsilons.length - 1];
    }

    public int getNumberOfDefinedEpsilons() {
        return this.epsilons.length;
    }

    @Override
    public int compare(Solution solution1, Solution solution2) {
        this.setSameBox(false);
        boolean dominate1 = false;
        boolean dominate2 = false;
        for (int i = 0; i < solution1.getNumberOfObjectives(); ++i) {
            double index2;
            double epsilon = this.getEpsilon(i);
            double index1 = Math.floor(solution1.getObjective(i) / epsilon);
            if (index1 < (index2 = Math.floor(solution2.getObjective(i) / epsilon))) {
                dominate1 = true;
                if (!dominate2) continue;
                return 0;
            }
            if (!(index1 > index2)) continue;
            dominate2 = true;
            if (!dominate1) continue;
            return 0;
        }
        if (!dominate1 && !dominate2) {
            this.setSameBox(true);
            double dist1 = 0.0;
            double dist2 = 0.0;
            for (int i = 0; i < solution1.getNumberOfObjectives(); ++i) {
                double epsilon = this.getEpsilon(i);
                double index1 = Math.floor(solution1.getObjective(i) / epsilon);
                double index2 = Math.floor(solution2.getObjective(i) / epsilon);
                dist1 += Math.pow(solution1.getObjective(i) - index1 * epsilon, 2.0);
                dist2 += Math.pow(solution2.getObjective(i) - index2 * epsilon, 2.0);
            }
            if (dist1 < dist2) {
                return -1;
            }
            return 1;
        }
        if (dominate1) {
            return -1;
        }
        return 1;
    }
}

