/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.fitness;

import org.moeaframework.core.FitnessEvaluator;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.FitnessComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;

public class FitnessBasedArchive
extends NondominatedPopulation {
    private final int capacity;
    private final FitnessEvaluator fitnessEvaluator;
    private final FitnessComparator fitnessComparator;

    public FitnessBasedArchive(FitnessEvaluator evaluator, int capacity) {
        this(evaluator, capacity, new ParetoDominanceComparator());
    }

    public FitnessBasedArchive(FitnessEvaluator evaluator, int capacity, DominanceComparator comparator) {
        super(comparator);
        this.fitnessEvaluator = evaluator;
        this.capacity = capacity;
        this.fitnessComparator = new FitnessComparator(evaluator.areLargerValuesPreferred());
    }

    public FitnessBasedArchive(FitnessEvaluator evaluator, int capacity, DominanceComparator comparator, Iterable<? extends Solution> iterable) {
        this(evaluator, capacity, comparator);
        this.addAll(iterable);
    }

    public FitnessBasedArchive(FitnessEvaluator evaluator, int capacity, Iterable<? extends Solution> iterable) {
        this(evaluator, capacity, new ParetoDominanceComparator(), iterable);
    }

    @Override
    public boolean add(Solution solution) {
        boolean solutionAdded = super.add(solution);
        if (solutionAdded && this.size() > this.capacity) {
            this.update();
            this.truncate(this.capacity, this.fitnessComparator);
        }
        return solutionAdded;
    }

    public void update() {
        this.fitnessEvaluator.evaluate(this);
    }
}

