/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.fitness;

import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.fitness.IndicatorFitnessEvaluator;

public class HypervolumeFitnessEvaluator
extends IndicatorFitnessEvaluator {
    public static final double rho = 2.0;
    private static final ParetoDominanceComparator dominanceComparator = new ParetoDominanceComparator();

    public HypervolumeFitnessEvaluator(Problem problem) {
        super(problem);
    }

    @Override
    protected double calculateIndicator(Solution solution1, Solution solution2) {
        if (dominanceComparator.compare(solution1, solution2) < 0) {
            return -this.calculateHypervolume(solution1, solution2, this.getProblem().getNumberOfObjectives());
        }
        return this.calculateHypervolume(solution2, solution1, this.getProblem().getNumberOfObjectives());
    }

    protected double calculateHypervolume(Solution solution1, Solution solution2, int d) {
        double max = 2.0;
        double a = solution1.getObjective(d - 1);
        double b = max;
        if (solution2 != null) {
            b = solution2.getObjective(d - 1);
        }
        double volume = 0.0;
        if (d == 1) {
            if (a < b) {
                volume = (b - a) / 2.0;
            }
        } else {
            volume = a < b ? this.calculateHypervolume(solution1, null, d - 1) * (b - a) / 2.0 + this.calculateHypervolume(solution1, solution2, d - 1) * (max - b) / 2.0 : this.calculateHypervolume(solution1, solution2, d - 1) * (max - a) / 2.0;
        }
        return volume;
    }

    @Override
    public boolean areLargerValuesPreferred() {
        return false;
    }
}

