/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.fitness;

import org.moeaframework.core.FitnessEvaluator;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.indicator.Normalizer;

public abstract class IndicatorFitnessEvaluator
implements FitnessEvaluator {
    private Problem problem;
    private static final double kappa = 0.05;
    private double maxAbsIndicatorValue;
    private double[][] fitcomp;

    public IndicatorFitnessEvaluator(Problem problem) {
        this.problem = problem;
    }

    public Problem getProblem() {
        return this.problem;
    }

    @Override
    public void evaluate(Population population) {
        int i;
        Normalizer normalizer = new Normalizer(this.problem, population);
        Population normalizedPopulation = normalizer.normalize(population);
        this.fitcomp = new double[population.size()][population.size()];
        this.maxAbsIndicatorValue = Double.NEGATIVE_INFINITY;
        for (i = 0; i < population.size(); ++i) {
            for (int j = 0; j < population.size(); ++j) {
                this.fitcomp[i][j] = this.calculateIndicator(normalizedPopulation.get(i), normalizedPopulation.get(j));
                if (!(Math.abs(this.fitcomp[i][j]) > this.maxAbsIndicatorValue)) continue;
                this.maxAbsIndicatorValue = Math.abs(this.fitcomp[i][j]);
            }
        }
        for (i = 0; i < population.size(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < population.size(); ++j) {
                if (i == j) continue;
                sum += Math.exp(-this.fitcomp[j][i] / this.maxAbsIndicatorValue / 0.05);
            }
            population.get(i).setAttribute("fitness", Double.valueOf(sum));
        }
    }

    public void removeAndUpdate(Population population, int removeIndex) {
        int i;
        if (this.fitcomp == null) {
            throw new FrameworkException("evaluate must be called first");
        }
        for (i = 0; i < population.size(); ++i) {
            if (i == removeIndex) continue;
            Solution solution = population.get(i);
            double fitness = (Double)solution.getAttribute("fitness");
            solution.setAttribute("fitness", Double.valueOf(fitness -= Math.exp(-this.fitcomp[removeIndex][i] / this.maxAbsIndicatorValue / 0.05)));
        }
        for (i = 0; i < population.size(); ++i) {
            for (int j = removeIndex + 1; j < population.size(); ++j) {
                this.fitcomp[i][j - 1] = this.fitcomp[i][j];
            }
            if (i <= removeIndex) continue;
            this.fitcomp[i - 1] = this.fitcomp[i];
        }
        population.remove(removeIndex);
    }

    protected abstract double calculateIndicator(Solution var1, Solution var2);
}

