/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.indicator.NormalizedIndicator;

public class AdditiveEpsilonIndicator
extends NormalizedIndicator {
    public AdditiveEpsilonIndicator(Problem problem, NondominatedPopulation referenceSet) {
        super(problem, referenceSet);
    }

    @Override
    public double evaluate(NondominatedPopulation approximationSet) {
        return AdditiveEpsilonIndicator.evaluate(this.problem, this.normalize(approximationSet), this.getNormalizedReferenceSet());
    }

    static double evaluate(Problem problem, NondominatedPopulation approximationSet, NondominatedPopulation referenceSet) {
        double eps_i = 0.0;
        for (int i = 0; i < referenceSet.size(); ++i) {
            Solution solution1 = referenceSet.get(i);
            double eps_j = Double.POSITIVE_INFINITY;
            for (int j = 0; j < approximationSet.size(); ++j) {
                Solution solution2 = approximationSet.get(j);
                double eps_k = 0.0;
                for (int k = 0; k < problem.getNumberOfObjectives(); ++k) {
                    eps_k = Math.max(eps_k, solution2.getObjective(k) - solution1.getObjective(k));
                }
                eps_j = Math.min(eps_j, eps_k);
            }
            eps_i = Math.max(eps_i, eps_j);
        }
        return eps_i;
    }
}

