/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.apache.commons.math3.util.MathArrays;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.Indicator;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.EpsilonBoxDominanceComparator;

public class Contribution
implements Indicator {
    private final NondominatedPopulation referenceSet;
    private final EpsilonBoxDominanceComparator comparator;

    public Contribution(NondominatedPopulation referenceSet) {
        this(referenceSet, (EpsilonBoxDominanceComparator)null);
    }

    public Contribution(NondominatedPopulation referenceSet, double epsilon) {
        this(referenceSet, new EpsilonBoxDominanceComparator(epsilon));
    }

    public Contribution(NondominatedPopulation referenceSet, double[] epsilon) {
        this(referenceSet, new EpsilonBoxDominanceComparator(epsilon));
    }

    public Contribution(NondominatedPopulation referenceSet, EpsilonBoxDominanceComparator comparator) {
        this.comparator = comparator;
        if (referenceSet.isEmpty()) {
            throw new IllegalArgumentException("reference set is empty");
        }
        this.referenceSet = comparator == null ? referenceSet : new EpsilonBoxDominanceArchive(comparator, (Iterable<? extends Solution>)referenceSet);
    }

    @Override
    public double evaluate(NondominatedPopulation approximationSet) {
        int count = 0;
        for (Solution solution1 : this.referenceSet) {
            boolean match = false;
            for (Solution solution2 : approximationSet) {
                if (this.comparator == null) {
                    double distance = MathArrays.distance((double[])solution1.getObjectives(), (double[])solution2.getObjectives());
                    if (!(distance < 1.0E-10)) continue;
                    match = true;
                    break;
                }
                this.comparator.compare(solution1, solution2);
                if (!this.comparator.isSameBox()) continue;
                match = true;
                break;
            }
            if (!match) continue;
            ++count;
        }
        return (double)count / (double)this.referenceSet.size();
    }
}

