/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Settings;
import org.moeaframework.core.indicator.IndicatorUtils;
import org.moeaframework.core.indicator.NormalizedIndicator;

public class GenerationalDistance
extends NormalizedIndicator {
    private final double d;

    public GenerationalDistance(Problem problem, NondominatedPopulation referenceSet) {
        this(problem, referenceSet, Settings.getGDPower());
    }

    public GenerationalDistance(Problem problem, NondominatedPopulation referenceSet, double d) {
        super(problem, referenceSet);
        this.d = d;
    }

    @Override
    public double evaluate(NondominatedPopulation approximationSet) {
        return GenerationalDistance.evaluate(this.problem, this.normalize(approximationSet), this.getNormalizedReferenceSet(), this.d);
    }

    static double evaluate(Problem problem, NondominatedPopulation approximationSet, NondominatedPopulation referenceSet, double d) {
        double sum = 0.0;
        if (approximationSet.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        for (int i = 0; i < approximationSet.size(); ++i) {
            sum += Math.pow(IndicatorUtils.distanceToNearestSolution(problem, approximationSet.get(i), referenceSet), d);
        }
        return Math.pow(sum, 1.0 / d) / (double)approximationSet.size();
    }
}

