/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Settings;
import org.moeaframework.core.Solution;
import org.moeaframework.core.indicator.NormalizedIndicator;
import org.moeaframework.util.io.RedirectStream;

public class Hypervolume
extends NormalizedIndicator {
    public Hypervolume(Problem problem, NondominatedPopulation referenceSet) {
        super(problem, referenceSet, true);
    }

    public Hypervolume(Problem problem, NondominatedPopulation referenceSet, double[] referencePoint) {
        super(problem, referenceSet, referencePoint);
    }

    public Hypervolume(Problem problem, double[] minimum, double[] maximum) {
        super(problem, new NondominatedPopulation(), minimum, maximum);
    }

    protected static void invert(Problem problem, Solution solution) {
        for (int j = 0; j < problem.getNumberOfObjectives(); ++j) {
            double value = solution.getObjective(j);
            if (value < 0.0) {
                value = 0.0;
            } else if (value > 1.0) {
                value = 1.0;
            }
            solution.setObjective(j, 1.0 - value);
        }
    }

    private static boolean dominates(Solution solution1, Solution solution2, int numberOfObjectives) {
        boolean betterInAnyObjective = false;
        boolean worseInAnyObjective = false;
        for (int i = 0; i < numberOfObjectives && !worseInAnyObjective; ++i) {
            if (solution1.getObjective(i) > solution2.getObjective(i)) {
                betterInAnyObjective = true;
                continue;
            }
            if (!(solution1.getObjective(i) < solution2.getObjective(i))) continue;
            worseInAnyObjective = true;
        }
        return !worseInAnyObjective && betterInAnyObjective;
    }

    private static void swap(List<Solution> population, int i, int j) {
        Solution temp = population.get(i);
        population.set(i, population.get(j));
        population.set(j, temp);
    }

    private static int filterNondominatedSet(List<Solution> population, int numberOfSolutions, int numberOfObjectives) {
        int n = numberOfSolutions;
        block0: for (int i = 0; i < n; ++i) {
            int j = i + 1;
            while (j < n) {
                if (Hypervolume.dominates(population.get(i), population.get(j), numberOfObjectives)) {
                    Hypervolume.swap(population, j, --n);
                    continue;
                }
                if (Hypervolume.dominates(population.get(j), population.get(i), numberOfObjectives)) {
                    Hypervolume.swap(population, i, --n);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
        return n;
    }

    private static double surfaceUnchangedTo(List<Solution> population, int numberOfSolutions, int objective) {
        double min = population.get(0).getObjective(objective);
        for (int i = 1; i < numberOfSolutions; ++i) {
            min = Math.min(min, population.get(i).getObjective(objective));
        }
        return min;
    }

    private static int reduceNondominatedSet(List<Solution> population, int numberOfSolutions, int objective, double threshold) {
        int n = numberOfSolutions;
        for (int i = 0; i < n; ++i) {
            if (!(population.get(i).getObjective(objective) <= threshold)) continue;
            Hypervolume.swap(population, i, --n);
        }
        return n;
    }

    public static double calculateHypervolume(List<Solution> population, int numberOfSolutions, int numberOfObjectives) {
        double volume = 0.0;
        double distance = 0.0;
        int n = numberOfSolutions;
        while (n > 0) {
            int numberOfNondominatedPoints = Hypervolume.filterNondominatedSet(population, n, numberOfObjectives - 1);
            double tempVolume = 0.0;
            tempVolume = numberOfObjectives < 3 ? population.get(0).getObjective(0) : Hypervolume.calculateHypervolume(population, numberOfNondominatedPoints, numberOfObjectives - 1);
            double tempDistance = Hypervolume.surfaceUnchangedTo(population, n, numberOfObjectives - 1);
            volume += tempVolume * (tempDistance - distance);
            distance = tempDistance;
            n = Hypervolume.reduceNondominatedSet(population, n, numberOfObjectives - 1, distance);
        }
        return volume;
    }

    @Override
    public double evaluate(NondominatedPopulation approximationSet) {
        return Hypervolume.evaluate(this.problem, this.normalize(approximationSet));
    }

    static double evaluate(Problem problem, NondominatedPopulation approximationSet) {
        boolean isCustomHypervolume;
        boolean isInverted = true;
        boolean bl = isCustomHypervolume = Settings.getHypervolume() != null && problem.getNumberOfObjectives() > 2;
        if (isCustomHypervolume) {
            isInverted = Settings.isHypervolumeInverted();
        }
        ArrayList<Solution> solutions = new ArrayList<Solution>();
        for (Solution solution : approximationSet) {
            for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
                if (!(solution.getObjective(i) > 1.0)) continue;
            }
            Solution clone = solution.copy();
            if (isInverted) {
                Hypervolume.invert(problem, clone);
            }
            solutions.add(clone);
        }
        if (isCustomHypervolume) {
            return Hypervolume.invokeNativeHypervolume(problem, solutions, isInverted);
        }
        return Hypervolume.calculateHypervolume(solutions, solutions.size(), problem.getNumberOfObjectives());
    }

    protected static double invokeNativeHypervolume(Problem problem, List<Solution> solutions, boolean isInverted) {
        try {
            int i;
            String command = Settings.getHypervolume();
            double nadirPoint = isInverted ? 0.0 : 1.0;
            File approximationSetFile = File.createTempFile("approximationSet", null);
            approximationSetFile.deleteOnExit();
            PopulationIO.writeObjectives(approximationSetFile, solutions);
            File referencePointFile = null;
            if (command.contains("{3}")) {
                referencePointFile = File.createTempFile("referencePoint", null);
                referencePointFile.deleteOnExit();
                Solution referencePoint = new Solution(new double[problem.getNumberOfObjectives()]);
                for (i = 0; i < problem.getNumberOfObjectives(); ++i) {
                    referencePoint.setObjective(i, nadirPoint);
                }
                PopulationIO.writeObjectives(referencePointFile, new Population(new Solution[]{referencePoint}));
            }
            StringBuilder referencePointString = null;
            if (command.contains("{4}")) {
                referencePointString = new StringBuilder();
                for (i = 0; i < problem.getNumberOfObjectives(); ++i) {
                    if (i > 0) {
                        referencePointString.append(' ');
                    }
                    referencePointString.append(nadirPoint);
                }
            }
            Object[] arguments = new Object[]{problem.getNumberOfObjectives(), solutions.size(), approximationSetFile.getCanonicalPath(), referencePointFile == null ? "" : referencePointFile.getCanonicalPath(), referencePointString == null ? "" : referencePointString.toString()};
            return Hypervolume.invokeNativeProcess(MessageFormat.format(command, arguments));
        }
        catch (IOException e) {
            throw new FrameworkException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double invokeNativeProcess(String command) throws IOException {
        Process process = new ProcessBuilder(Settings.parseCommand(command)).start();
        RedirectStream.redirect(process.getErrorStream(), System.err);
        BufferedReader reader = null;
        String lastLine = null;
        try {
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                lastLine = line;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        String[] tokens = lastLine.split("\\s+");
        return Double.parseDouble(tokens[tokens.length - 1]);
    }
}

