/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;

public class IndicatorUtils {
    private IndicatorUtils() {
    }

    public static double manhattanDistance(Problem problem, Solution a, Solution b) {
        return IndicatorUtils.distance(problem, a, b, 1.0);
    }

    public static double euclideanDistance(Problem problem, Solution a, Solution b) {
        return IndicatorUtils.distance(problem, a, b, 2.0);
    }

    private static double distance(Problem problem, Solution a, Solution b, double power) {
        double distance = 0.0;
        for (int i = 0; i < problem.getNumberOfObjectives(); ++i) {
            distance += Math.pow(Math.abs(a.getObjective(i) - b.getObjective(i)), power);
        }
        return Math.pow(distance, 1.0 / power);
    }

    public static double distanceToNearestSolution(Problem problem, Solution solution, NondominatedPopulation population) {
        double minimum = Double.POSITIVE_INFINITY;
        for (int i = 0; i < population.size(); ++i) {
            minimum = Math.min(minimum, IndicatorUtils.euclideanDistance(problem, solution, population.get(i)));
        }
        return minimum;
    }
}

