/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Settings;
import org.moeaframework.core.indicator.IndicatorUtils;
import org.moeaframework.core.indicator.NormalizedIndicator;

public class InvertedGenerationalDistance
extends NormalizedIndicator {
    private final double d;

    public InvertedGenerationalDistance(Problem problem, NondominatedPopulation referenceSet) {
        this(problem, referenceSet, Settings.getIGDPower());
    }

    public InvertedGenerationalDistance(Problem problem, NondominatedPopulation referenceSet, double d) {
        super(problem, referenceSet);
        this.d = d;
    }

    @Override
    public double evaluate(NondominatedPopulation approximationSet) {
        return InvertedGenerationalDistance.evaluate(this.problem, this.normalize(approximationSet), this.getNormalizedReferenceSet(), this.d);
    }

    static double evaluate(Problem problem, NondominatedPopulation approximationSet, NondominatedPopulation referenceSet, double d) {
        double sum = 0.0;
        for (int i = 0; i < referenceSet.size(); ++i) {
            sum += Math.pow(IndicatorUtils.distanceToNearestSolution(problem, referenceSet.get(i), approximationSet), d);
        }
        return Math.pow(sum, 1.0 / d) / (double)referenceSet.size();
    }
}

