/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.moeaframework.core.Indicator;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Settings;
import org.moeaframework.core.indicator.Normalizer;

public abstract class NormalizedIndicator
implements Indicator {
    protected final Problem problem;
    private final Normalizer normalizer;
    private final NondominatedPopulation normalizedReferenceSet;

    public NormalizedIndicator(Problem problem, NondominatedPopulation referenceSet) {
        this(problem, referenceSet, false);
    }

    public NormalizedIndicator(Problem problem, NondominatedPopulation referenceSet, boolean useReferencePoint) {
        this.problem = problem;
        if (useReferencePoint) {
            double[] idealPoint = Settings.getIdealPoint(problem.getName());
            double[] referencePoint = Settings.getReferencePoint(problem.getName());
            this.normalizer = idealPoint != null && referencePoint != null ? new Normalizer(problem, idealPoint, referencePoint) : (referencePoint != null ? new Normalizer(problem, (Population)referenceSet, referencePoint) : new Normalizer(problem, (Population)referenceSet, Settings.getHypervolumeDelta()));
        } else {
            this.normalizer = new Normalizer(problem, referenceSet);
        }
        this.normalizedReferenceSet = this.normalizer.normalize(referenceSet);
    }

    public NormalizedIndicator(Problem problem, NondominatedPopulation referenceSet, double[] referencePoint) {
        this.problem = problem;
        this.normalizer = new Normalizer(problem, (Population)referenceSet, referencePoint);
        this.normalizedReferenceSet = this.normalizer.normalize(referenceSet);
    }

    public NormalizedIndicator(Problem problem, NondominatedPopulation referenceSet, double[] minimum, double[] maximum) {
        this.problem = problem;
        this.normalizer = new Normalizer(problem, minimum, maximum);
        this.normalizedReferenceSet = this.normalizer.normalize(referenceSet);
    }

    protected NondominatedPopulation normalize(NondominatedPopulation approximationSet) {
        return this.normalizer.normalize(approximationSet);
    }

    protected NondominatedPopulation getNormalizedReferenceSet() {
        return this.normalizedReferenceSet;
    }
}

