/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import java.util.Arrays;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;

public class Normalizer {
    private final Problem problem;
    private final double delta;
    private final double[] referencePoint;
    private final double[] minimum;
    private final double[] maximum;

    public Normalizer(Problem problem, Population population) {
        this.problem = problem;
        this.delta = 0.0;
        this.referencePoint = null;
        this.minimum = new double[problem.getNumberOfObjectives()];
        this.maximum = new double[problem.getNumberOfObjectives()];
        this.calculateRanges(population);
        this.checkRanges();
    }

    public Normalizer(Problem problem, Population population, double delta) {
        this.problem = problem;
        this.delta = delta;
        this.referencePoint = null;
        this.minimum = new double[problem.getNumberOfObjectives()];
        this.maximum = new double[problem.getNumberOfObjectives()];
        this.calculateRanges(population);
        this.checkRanges();
    }

    public Normalizer(Problem problem, Population population, double[] referencePoint) {
        this.problem = problem;
        this.delta = 0.0;
        this.referencePoint = (double[])referencePoint.clone();
        this.minimum = new double[problem.getNumberOfObjectives()];
        this.maximum = new double[problem.getNumberOfObjectives()];
        this.calculateRanges(population);
        this.checkRanges();
    }

    public Normalizer(Problem problem, double[] minimum, double[] maximum) {
        this.problem = problem;
        this.delta = 0.0;
        this.referencePoint = null;
        this.minimum = new double[problem.getNumberOfObjectives()];
        this.maximum = new double[problem.getNumberOfObjectives()];
        for (int j = 0; j < problem.getNumberOfObjectives(); ++j) {
            this.minimum[j] = minimum[j >= minimum.length ? minimum.length - 1 : j];
            this.maximum[j] = maximum[j >= maximum.length ? maximum.length - 1 : j];
        }
        this.checkRanges();
    }

    private void calculateRanges(Population population) {
        int j;
        int i;
        if (population.size() < 2) {
            throw new IllegalArgumentException("requires at least two solutions");
        }
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.minimum[i] = Double.POSITIVE_INFINITY;
            this.maximum[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < population.size(); ++i) {
            Solution solution = population.get(i);
            if (solution.violatesConstraints()) continue;
            for (int j2 = 0; j2 < this.problem.getNumberOfObjectives(); ++j2) {
                this.minimum[j2] = Math.min(this.minimum[j2], solution.getObjective(j2));
                this.maximum[j2] = Math.max(this.maximum[j2], solution.getObjective(j2));
            }
        }
        if (this.referencePoint != null) {
            for (j = 0; j < this.problem.getNumberOfObjectives(); ++j) {
                this.maximum[j] = this.referencePoint[j >= this.referencePoint.length ? this.referencePoint.length - 1 : j];
            }
            System.err.println("Using reference point: " + Arrays.toString(this.maximum));
        } else if (this.delta > 0.0) {
            for (j = 0; j < this.problem.getNumberOfObjectives(); ++j) {
                int n = j;
                this.maximum[n] = this.maximum[n] + this.delta * (this.maximum[j] - this.minimum[j]);
            }
            System.err.println("Using reference point: " + Arrays.toString(this.maximum));
        }
    }

    private void checkRanges() {
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            if (!(Math.abs(this.minimum[i] - this.maximum[i]) < 1.0E-10)) continue;
            throw new IllegalArgumentException("objective with empty range");
        }
    }

    public NondominatedPopulation normalize(NondominatedPopulation population) {
        NondominatedPopulation result = new NondominatedPopulation(){

            @Override
            public boolean add(Solution newSolution) {
                return super.forceAddWithoutCheck(newSolution);
            }
        };
        this.normalize(population, result);
        return result;
    }

    public Population normalize(Population population) {
        Population result = new Population();
        this.normalize(population, result);
        return result;
    }

    private void normalize(Population originalSet, Population normalizedSet) {
        for (Solution solution : originalSet) {
            if (solution.violatesConstraints()) continue;
            Solution clone = solution.copy();
            for (int j = 0; j < this.problem.getNumberOfObjectives(); ++j) {
                clone.setObjective(j, (clone.getObjective(j) - this.minimum[j]) / (this.maximum[j] - this.minimum[j]));
            }
            normalizedSet.add(clone);
        }
    }
}

