/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Settings;
import org.moeaframework.core.indicator.AdditiveEpsilonIndicator;
import org.moeaframework.core.indicator.GenerationalDistance;
import org.moeaframework.core.indicator.Hypervolume;
import org.moeaframework.core.indicator.InvertedGenerationalDistance;
import org.moeaframework.core.indicator.MaximumParetoFrontError;
import org.moeaframework.core.indicator.Normalizer;
import org.moeaframework.core.indicator.Spacing;

public class QualityIndicator {
    private final Problem problem;
    private final NondominatedPopulation referenceSet;
    private final NondominatedPopulation normalizedReferenceSet;
    private final Normalizer normalizer;
    private final Normalizer hypervolumeNormalizer;
    private NondominatedPopulation normalizedApproximationSet;
    private double generationalDistance;
    private double invertedGenerationalDistance;
    private double additiveEpsilonIndicator;
    private double hypervolume;
    private double maximumParetoFrontError;
    private double spacing;

    public QualityIndicator(Problem problem, NondominatedPopulation referenceSet) {
        this.problem = problem;
        this.referenceSet = referenceSet;
        this.normalizer = new Normalizer(problem, referenceSet);
        this.normalizedReferenceSet = this.normalizer.normalize(referenceSet);
        this.hypervolumeNormalizer = new Normalizer(problem, (Population)referenceSet, Settings.getHypervolumeDelta());
    }

    public Problem getProblem() {
        return this.problem;
    }

    public double getGenerationalDistance() {
        this.checkCalculateInvocation();
        return this.generationalDistance;
    }

    public double getInvertedGenerationalDistance() {
        this.checkCalculateInvocation();
        return this.invertedGenerationalDistance;
    }

    public double getAdditiveEpsilonIndicator() {
        this.checkCalculateInvocation();
        return this.additiveEpsilonIndicator;
    }

    public double getHypervolume() {
        this.checkCalculateInvocation();
        return this.hypervolume;
    }

    public double getMaximumParetoFrontError() {
        this.checkCalculateInvocation();
        return this.maximumParetoFrontError;
    }

    public double getSpacing() {
        this.checkCalculateInvocation();
        return this.spacing;
    }

    public NondominatedPopulation getReferenceSet() {
        return this.referenceSet;
    }

    private void checkCalculateInvocation() {
        if (this.normalizedApproximationSet == null) {
            throw new IllegalStateException("invoke calculate prior to getting indicator values");
        }
    }

    public void calculate(NondominatedPopulation approximationSet) {
        this.hypervolume = Settings.isHypervolumeEnabled() ? Hypervolume.evaluate(this.problem, this.hypervolumeNormalizer.normalize(approximationSet)) : Double.NaN;
        this.normalizedApproximationSet = this.normalizer.normalize(approximationSet);
        this.generationalDistance = GenerationalDistance.evaluate(this.problem, this.normalizedApproximationSet, this.normalizedReferenceSet, Settings.getGDPower());
        this.invertedGenerationalDistance = InvertedGenerationalDistance.evaluate(this.problem, this.normalizedApproximationSet, this.normalizedReferenceSet, Settings.getIGDPower());
        this.additiveEpsilonIndicator = AdditiveEpsilonIndicator.evaluate(this.problem, this.normalizedApproximationSet, this.normalizedReferenceSet);
        this.maximumParetoFrontError = MaximumParetoFrontError.evaluate(this.problem, this.normalizedApproximationSet, this.normalizedReferenceSet);
        this.spacing = Spacing.evaluate(this.problem, approximationSet);
    }
}

