/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.indicator.RIndicator;

public class R1Indicator
extends RIndicator {
    public static final double DEFAULT_EPSILON = 1.0E-5;
    private double epsilon;

    public R1Indicator(Problem problem, int subdivisions, NondominatedPopulation referenceSet) {
        this(problem, subdivisions, referenceSet, new RIndicator.ChebychevUtility());
    }

    public R1Indicator(Problem problem, int subdivisions, NondominatedPopulation referenceSet, RIndicator.UtilityFunction utilityFunction) {
        this(problem, subdivisions, referenceSet, utilityFunction, 1.0E-5);
    }

    public R1Indicator(Problem problem, int subdivisions, NondominatedPopulation referenceSet, RIndicator.UtilityFunction utilityFunction, double epsilon) {
        super(problem, subdivisions, referenceSet, utilityFunction);
        this.epsilon = epsilon;
    }

    @Override
    public double evaluate(NondominatedPopulation population) {
        double sum = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            double max1 = Double.NEGATIVE_INFINITY;
            double max2 = Double.NEGATIVE_INFINITY;
            for (Solution solution : population) {
                max1 = Math.max(max1, this.utilityFunction.computeUtility(solution, this.weights[i]));
            }
            for (Solution solution : this.getNormalizedReferenceSet()) {
                max2 = Math.max(max2, this.utilityFunction.computeUtility(solution, this.weights[i]));
            }
            if (Math.abs(max2 - max1) < this.epsilon) {
                sum += 0.5;
                continue;
            }
            if (!(max1 > max2)) continue;
            sum += 1.0;
        }
        return sum / (double)this.weights.length;
    }
}

