/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.indicator.RIndicator;

public class R3Indicator
extends RIndicator {
    public R3Indicator(Problem problem, int subdivisions, NondominatedPopulation referenceSet) {
        this(problem, subdivisions, referenceSet, new RIndicator.ChebychevUtility());
    }

    public R3Indicator(Problem problem, int subdivisions, NondominatedPopulation referenceSet, RIndicator.UtilityFunction utilityFunction) {
        super(problem, subdivisions, referenceSet, utilityFunction);
    }

    @Override
    public double evaluate(NondominatedPopulation population) {
        double sum = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            double max1 = Double.NEGATIVE_INFINITY;
            double max2 = Double.NEGATIVE_INFINITY;
            for (Solution solution : population) {
                max1 = Math.max(max1, this.utilityFunction.computeUtility(solution, this.weights[i]));
            }
            for (Solution solution : this.getNormalizedReferenceSet()) {
                max2 = Math.max(max2, this.utilityFunction.computeUtility(solution, this.weights[i]));
            }
            sum += (max2 - max1) / (max2 + 1.0E-30);
        }
        return sum / (double)this.weights.length;
    }
}

