/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.indicator.NormalizedIndicator;

public abstract class RIndicator
extends NormalizedIndicator {
    protected UtilityFunction utilityFunction;
    protected double[][] weights;

    public RIndicator(Problem problem, int subdivisions, NondominatedPopulation referenceSet) {
        this(problem, subdivisions, referenceSet, new ChebychevUtility());
    }

    public RIndicator(Problem problem, int subdivisions, NondominatedPopulation referenceSet, UtilityFunction utilityFunction) {
        super(problem, referenceSet);
        this.utilityFunction = utilityFunction;
        this.weights = RIndicator.generateUniformWeights(subdivisions, problem.getNumberOfObjectives());
    }

    public double expectedUtility(NondominatedPopulation population) {
        double sum = 0.0;
        for (int i = 0; i < this.weights.length; ++i) {
            double max = Double.NEGATIVE_INFINITY;
            for (Solution solution : population) {
                max = Math.max(max, this.utilityFunction.computeUtility(solution, this.weights[i]));
            }
            sum += max;
        }
        return sum / (double)this.weights.length;
    }

    private static double[][] generateUniformWeights(int s, int k) {
        int counter = 0;
        int N = ArithmeticUtils.pow((int)(s + 1), (int)k);
        double[][] weights = new double[(int)CombinatoricsUtils.binomialCoefficient((int)(s + k - 1), (int)(k - 1))][k];
        for (int i = 0; i < N; ++i) {
            int j;
            int sum = 0;
            int[] kary = RIndicator.toBaseK(i, s + 1, k);
            for (j = 0; j < k; ++j) {
                sum += kary[j];
            }
            if (sum != s) continue;
            for (j = 0; j < k; ++j) {
                weights[counter][j] = (double)kary[j] / (double)s;
            }
            ++counter;
        }
        return weights;
    }

    private static int[] toBaseK(int number, int k, int length) {
        int value = length - 1;
        int[] kary = new int[length];
        int i = 0;
        if (number >= ArithmeticUtils.pow((int)k, (int)length)) {
            throw new FrameworkException("number can not be represented in base-k with specified number of digits");
        }
        while (number != 0) {
            if (number >= ArithmeticUtils.pow((int)k, (int)value)) {
                int n = i;
                kary[n] = kary[n] + 1;
                number -= ArithmeticUtils.pow((int)k, (int)value);
                continue;
            }
            --value;
            ++i;
        }
        return kary;
    }

    public static int getDefaultSubdivisions(Problem problem) {
        switch (problem.getNumberOfObjectives()) {
            case 2: {
                return 500;
            }
            case 3: {
                return 30;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 8;
            }
        }
        return 3;
    }

    public static class ChebychevUtility
    implements UtilityFunction {
        @Override
        public double computeUtility(Solution solution, double[] weights) {
            double max = 0.0;
            for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
                max = Math.max(max, weights[i] * solution.getObjective(i));
            }
            return 1.0 - max;
        }
    }

    public static class LinearWeightedSumUtility
    implements UtilityFunction {
        @Override
        public double computeUtility(Solution solution, double[] weights) {
            double sum = 0.0;
            for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
                sum += weights[i] * solution.getObjective(i);
            }
            return 1.0 - sum;
        }
    }

    public static interface UtilityFunction {
        public double computeUtility(Solution var1, double[] var2);
    }
}

