/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.indicator;

import org.apache.commons.math3.stat.StatUtils;
import org.moeaframework.core.Indicator;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.indicator.IndicatorUtils;

public class Spacing
implements Indicator {
    private final Problem problem;

    public Spacing(Problem problem) {
        this.problem = problem;
    }

    @Override
    public double evaluate(NondominatedPopulation approximationSet) {
        return Spacing.evaluate(this.problem, approximationSet);
    }

    static double evaluate(Problem problem, NondominatedPopulation approximationSet) {
        if (approximationSet.size() < 2) {
            return 0.0;
        }
        double[] d = new double[approximationSet.size()];
        for (int i = 0; i < approximationSet.size(); ++i) {
            double min = Double.POSITIVE_INFINITY;
            Solution solutionI = approximationSet.get(i);
            if (solutionI.violatesConstraints()) continue;
            for (int j = 0; j < approximationSet.size(); ++j) {
                Solution solutionJ;
                if (i == j || (solutionJ = approximationSet.get(j)).violatesConstraints()) continue;
                min = Math.min(min, IndicatorUtils.manhattanDistance(problem, solutionI, solutionJ));
            }
            d[i] = min;
        }
        double dbar = StatUtils.sum((double[])d) / (double)approximationSet.size();
        double sum = 0.0;
        for (int i = 0; i < approximationSet.size(); ++i) {
            if (approximationSet.get(i).violatesConstraints()) continue;
            sum += Math.pow(d[i] - dbar, 2.0);
        }
        return Math.sqrt(sum / (double)(approximationSet.size() - 1));
    }
}

