/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;

public class AdaptiveMultimethodVariation
implements Variation {
    public static final String OPERATOR_ATTRIBUTE = "operator";
    private List<Variation> operators;
    private double[] probabilities;
    private int lastUpdate;
    private final Population archive;
    private static final int UPDATE_WINDOW = 100;

    public AdaptiveMultimethodVariation(Population archive) {
        this.archive = archive;
        this.operators = new ArrayList<Variation>();
    }

    public int getUpdateWindow() {
        return 100;
    }

    public void addOperator(Variation operator) {
        this.operators.add(operator);
    }

    public int getNumberOfOperators() {
        return this.operators.size();
    }

    public Variation getOperator(int index) {
        return this.operators.get(index);
    }

    public double getOperatorProbability(int index) {
        if (this.probabilities == null) {
            this.lastUpdate = 0;
            this.probabilities = this.getOperatorProbabilities();
        }
        return this.probabilities[index];
    }

    protected double[] getOperatorProbabilities() {
        double[] count = new double[this.operators.size()];
        Arrays.fill(count, 1.0);
        for (Solution solution : this.archive) {
            if (!solution.hasAttribute(OPERATOR_ATTRIBUTE)) continue;
            int n = (Integer)solution.getAttribute(OPERATOR_ATTRIBUTE);
            count[n] = count[n] + 1.0;
        }
        double sum = StatUtils.sum((double[])count);
        double[] probabilities = new double[count.length];
        for (int i = 0; i < count.length; ++i) {
            probabilities[i] = count[i] / sum;
        }
        return probabilities;
    }

    protected int selectOperator() {
        ++this.lastUpdate;
        if (this.lastUpdate >= 100 || this.probabilities == null) {
            this.lastUpdate = 0;
            this.probabilities = this.getOperatorProbabilities();
        }
        double rand = PRNG.nextDouble();
        double sum = 0.0;
        for (int i = 0; i < this.operators.size(); ++i) {
            if (!((sum += this.probabilities[i]) > rand)) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        if (this.operators.isEmpty()) {
            throw new IllegalStateException("no operators added");
        }
        int index = this.selectOperator();
        Variation operator = this.operators.get(index);
        Solution[] result = operator.evolve(Arrays.copyOf(parents, operator.getArity()));
        for (int i = 0; i < result.length; ++i) {
            result[i].setAttribute(OPERATOR_ATTRIBUTE, Integer.valueOf(index));
        }
        return result;
    }

    @Override
    public int getArity() {
        if (this.operators.isEmpty()) {
            throw new IllegalStateException("no operators added");
        }
        int arity = 0;
        for (Variation operator : this.operators) {
            arity = Math.max(arity, operator.getArity());
        }
        return arity;
    }
}

