/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;

public class CompoundVariation
implements Variation {
    private final List<Variation> operators = new ArrayList<Variation>();
    private String name;

    public CompoundVariation() {
    }

    public CompoundVariation(Variation ... operators) {
        this();
        for (Variation operator : operators) {
            this.appendOperator(operator);
        }
    }

    public String getName() {
        if (this.name == null) {
            StringBuilder sb = new StringBuilder();
            for (Variation operator : this.operators) {
                if (sb.length() > 0) {
                    sb.append('+');
                }
                sb.append(operator.getClass().getSimpleName());
            }
            return sb.toString();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void appendOperator(Variation variation) {
        this.operators.add(variation);
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution[] result = Arrays.copyOf(parents, parents.length);
        for (Variation operator : this.operators) {
            if (result.length == operator.getArity()) {
                result = operator.evolve(result);
                continue;
            }
            if (operator.getArity() == 1) {
                for (int j = 0; j < result.length; ++j) {
                    result[j] = operator.evolve(new Solution[]{result[j]})[0];
                }
                continue;
            }
            throw new FrameworkException("invalid number of parents");
        }
        return result;
    }

    @Override
    public int getArity() {
        return this.operators.get(0).getArity();
    }
}

