/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.operator.RandomInitialization;

public class InjectedInitialization
extends RandomInitialization {
    private List<Solution> injectedSolutions;

    public InjectedInitialization(Problem problem, int populationSize, Solution ... injectedSolutions) {
        this(problem, populationSize, Arrays.asList(injectedSolutions));
    }

    public InjectedInitialization(Problem problem, int populationSize, List<Solution> injectedSolutions) {
        super(problem, populationSize);
        this.injectedSolutions = new ArrayList<Solution>(injectedSolutions);
    }

    @Override
    public Solution[] initialize() {
        if (this.populationSize <= this.injectedSolutions.size()) {
            return this.injectedSolutions.toArray(new Solution[0]);
        }
        Solution[] initialPopulation = super.initialize();
        for (int i = 0; i < this.injectedSolutions.size(); ++i) {
            initialPopulation[i] = this.injectedSolutions.get(i);
        }
        return initialPopulation;
    }
}

