/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator;

import java.util.HashSet;
import java.util.Properties;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.operator.OnePointCrossover;
import org.moeaframework.core.operator.TwoPointCrossover;
import org.moeaframework.core.operator.UniformCrossover;
import org.moeaframework.core.operator.binary.BitFlip;
import org.moeaframework.core.operator.binary.HUX;
import org.moeaframework.core.operator.grammar.GrammarCrossover;
import org.moeaframework.core.operator.grammar.GrammarMutation;
import org.moeaframework.core.operator.permutation.Insertion;
import org.moeaframework.core.operator.permutation.PMX;
import org.moeaframework.core.operator.permutation.Swap;
import org.moeaframework.core.operator.program.PointMutation;
import org.moeaframework.core.operator.program.SubtreeCrossover;
import org.moeaframework.core.operator.real.AdaptiveMetropolis;
import org.moeaframework.core.operator.real.DifferentialEvolution;
import org.moeaframework.core.operator.real.PCX;
import org.moeaframework.core.operator.real.PM;
import org.moeaframework.core.operator.real.SBX;
import org.moeaframework.core.operator.real.SPX;
import org.moeaframework.core.operator.real.UM;
import org.moeaframework.core.operator.real.UNDX;
import org.moeaframework.core.operator.subset.Replace;
import org.moeaframework.core.operator.subset.SSX;
import org.moeaframework.core.spi.OperatorProvider;
import org.moeaframework.core.spi.ProviderLookupException;
import org.moeaframework.core.variable.BinaryVariable;
import org.moeaframework.core.variable.Grammar;
import org.moeaframework.core.variable.Permutation;
import org.moeaframework.core.variable.Program;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.core.variable.Subset;
import org.moeaframework.util.TypedProperties;

public class StandardOperators
extends OperatorProvider {
    @Override
    public String getMutationHint(Problem problem) {
        HashSet types = new HashSet();
        Solution solution = problem.newSolution();
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            Variable variable = solution.getVariable(i);
            if (variable == null) {
                throw new ProviderLookupException("variable is null");
            }
            types.add(variable.getClass());
        }
        if (types.isEmpty() || types.size() > 1) {
            return null;
        }
        Class type = (Class)types.iterator().next();
        if (RealVariable.class.isAssignableFrom(type)) {
            return "pm";
        }
        if (BinaryVariable.class.isAssignableFrom(type)) {
            return "bf";
        }
        if (Permutation.class.isAssignableFrom(type)) {
            return "insertion+swap";
        }
        if (Grammar.class.isAssignableFrom(type)) {
            return "gm";
        }
        if (Program.class.isAssignableFrom(type)) {
            return "ptm";
        }
        if (Subset.class.isAssignableFrom(type)) {
            return "replace";
        }
        return null;
    }

    @Override
    public String getVariationHint(Problem problem) {
        HashSet types = new HashSet();
        Solution solution = problem.newSolution();
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            Variable variable = solution.getVariable(i);
            if (variable == null) {
                throw new ProviderLookupException("variable is null");
            }
            types.add(variable.getClass());
        }
        if (types.isEmpty() || types.size() > 1) {
            return null;
        }
        Class type = (Class)types.iterator().next();
        if (RealVariable.class.isAssignableFrom(type)) {
            return "sbx+pm";
        }
        if (BinaryVariable.class.isAssignableFrom(type)) {
            return "hux+bf";
        }
        if (Permutation.class.isAssignableFrom(type)) {
            return "pmx+insertion+swap";
        }
        if (Grammar.class.isAssignableFrom(type)) {
            return "gx+gm";
        }
        if (Program.class.isAssignableFrom(type)) {
            return "bx+ptm";
        }
        if (Subset.class.isAssignableFrom(type)) {
            return "ssx+replace";
        }
        return null;
    }

    @Override
    public Variation getVariation(String name, Properties properties, Problem problem) {
        TypedProperties typedProperties = new TypedProperties(properties);
        if (name.equalsIgnoreCase("sbx")) {
            return new SBX(typedProperties.getDouble("sbx.rate", 1.0), typedProperties.getDouble("sbx.distributionIndex", 15.0), typedProperties.getBoolean("sbx.swap", true), typedProperties.getBoolean("sbx.symmetric", false));
        }
        if (name.equalsIgnoreCase("pm")) {
            return new PM(typedProperties.getDouble("pm.rate", 1.0 / (double)problem.getNumberOfVariables()), typedProperties.getDouble("pm.distributionIndex", 20.0));
        }
        if (name.equalsIgnoreCase("de")) {
            return new DifferentialEvolution(typedProperties.getDouble("de.crossoverRate", 0.1), typedProperties.getDouble("de.stepSize", 0.5));
        }
        if (name.equalsIgnoreCase("pcx")) {
            return new PCX((int)typedProperties.getDouble("pcx.parents", 10.0), (int)typedProperties.getDouble("pcx.offspring", 2.0), typedProperties.getDouble("pcx.eta", 0.1), typedProperties.getDouble("pcx.zeta", 0.1));
        }
        if (name.equalsIgnoreCase("spx")) {
            return new SPX((int)typedProperties.getDouble("spx.parents", 10.0), (int)typedProperties.getDouble("spx.offspring", 2.0), typedProperties.getDouble("spx.epsilon", 3.0));
        }
        if (name.equalsIgnoreCase("undx")) {
            return new UNDX((int)typedProperties.getDouble("undx.parents", 10.0), (int)typedProperties.getDouble("undx.offspring", 2.0), typedProperties.getDouble("undx.zeta", 0.5), typedProperties.getDouble("undx.eta", 0.35));
        }
        if (name.equalsIgnoreCase("um")) {
            return new UM(typedProperties.getDouble("um.rate", 1.0 / (double)problem.getNumberOfVariables()));
        }
        if (name.equalsIgnoreCase("am")) {
            return new AdaptiveMetropolis((int)typedProperties.getDouble("am.parents", 10.0), (int)typedProperties.getDouble("am.offspring", 2.0), typedProperties.getDouble("am.coefficient", 2.4));
        }
        if (name.equalsIgnoreCase("hux")) {
            return new HUX(typedProperties.getDouble("hux.rate", 1.0));
        }
        if (name.equalsIgnoreCase("bf")) {
            return new BitFlip(typedProperties.getDouble("bf.rate", 0.01));
        }
        if (name.equalsIgnoreCase("pmx")) {
            return new PMX(typedProperties.getDouble("pmx.rate", 1.0));
        }
        if (name.equalsIgnoreCase("insertion")) {
            return new Insertion(typedProperties.getDouble("insertion.rate", 0.3));
        }
        if (name.equalsIgnoreCase("swap")) {
            return new Swap(typedProperties.getDouble("swap.rate", 0.3));
        }
        if (name.equalsIgnoreCase("1x")) {
            return new OnePointCrossover(typedProperties.getDouble("1x.rate", 1.0));
        }
        if (name.equalsIgnoreCase("2x")) {
            return new TwoPointCrossover(typedProperties.getDouble("2x.rate", 1.0));
        }
        if (name.equalsIgnoreCase("ux")) {
            return new UniformCrossover(typedProperties.getDouble("ux.rate", 1.0));
        }
        if (name.equalsIgnoreCase("gx")) {
            return new GrammarCrossover(typedProperties.getDouble("gx.rate", 1.0));
        }
        if (name.equalsIgnoreCase("gm")) {
            return new GrammarMutation(typedProperties.getDouble("gm.rate", 1.0));
        }
        if (name.equalsIgnoreCase("ptm")) {
            return new PointMutation(typedProperties.getDouble("ptm.rate", 0.01));
        }
        if (name.equalsIgnoreCase("bx")) {
            return new SubtreeCrossover(typedProperties.getDouble("bx.rate", 0.9));
        }
        if (name.equalsIgnoreCase("replace")) {
            return new Replace(typedProperties.getDouble("replace.rate", 0.9));
        }
        if (name.equalsIgnoreCase("ssx")) {
            return new SSX(typedProperties.getDouble("ssx.rate", 0.3));
        }
        return null;
    }
}

