/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;

public class TournamentSelection
implements Selection {
    private final DominanceComparator comparator;
    private int size;

    public TournamentSelection() {
        this(2);
    }

    public TournamentSelection(DominanceComparator comparator) {
        this(2, comparator);
    }

    public TournamentSelection(int size) {
        this(size, new ParetoDominanceComparator());
    }

    public TournamentSelection(int size, DominanceComparator comparator) {
        this.size = size;
        this.comparator = comparator;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public DominanceComparator getComparator() {
        return this.comparator;
    }

    @Override
    public Solution[] select(int arity, Population population) {
        Solution[] result = new Solution[arity];
        for (int i = 0; i < arity; ++i) {
            result[i] = this.select(population);
        }
        return result;
    }

    private Solution select(Population population) {
        Solution winner = population.get(PRNG.nextInt(population.size()));
        for (int i = 1; i < this.size; ++i) {
            Solution candidate = population.get(PRNG.nextInt(population.size()));
            int flag = this.comparator.compare(winner, candidate);
            if (flag <= 0) continue;
            winner = candidate;
        }
        return winner;
    }

    public static Solution binaryTournament(Solution solution1, Solution solution2, DominanceComparator comparator) {
        int flag = comparator.compare(solution1, solution2);
        if (flag > 0) {
            return solution2;
        }
        return solution1;
    }

    public static Solution binaryTournament(Solution solution1, Solution solution2) {
        return TournamentSelection.binaryTournament(solution1, solution2, new ParetoDominanceComparator());
    }
}

