/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;

public class TwoPointCrossover
implements Variation {
    private final double probability;

    public TwoPointCrossover(double probability) {
        this.probability = probability;
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result1 = parents[0].copy();
        Solution result2 = parents[1].copy();
        if (PRNG.nextDouble() <= this.probability && result1.getNumberOfVariables() > 1) {
            int crossoverPoint2;
            int crossoverPoint1 = PRNG.nextInt(result1.getNumberOfVariables() - 1);
            if (crossoverPoint1 > (crossoverPoint2 = PRNG.nextInt(result1.getNumberOfVariables() - 1))) {
                int temp = crossoverPoint1;
                crossoverPoint1 = crossoverPoint2;
                crossoverPoint2 = temp;
            }
            for (int i = crossoverPoint1; i <= crossoverPoint2; ++i) {
                Variable temp = result1.getVariable(i);
                result1.setVariable(i, result2.getVariable(i));
                result2.setVariable(i, temp);
            }
        }
        return new Solution[]{result1, result2};
    }

    @Override
    public int getArity() {
        return 2;
    }
}

