/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;

public class UniformCrossover
implements Variation {
    private final double probability;

    public UniformCrossover(double probability) {
        this.probability = probability;
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result1 = parents[0].copy();
        Solution result2 = parents[1].copy();
        if (PRNG.nextDouble() <= this.probability) {
            for (int i = 0; i < result1.getNumberOfVariables(); ++i) {
                if (!PRNG.nextBoolean()) continue;
                Variable temp = result1.getVariable(i);
                result1.setVariable(i, result2.getVariable(i));
                result2.setVariable(i, temp);
            }
        }
        return new Solution[]{result1, result2};
    }

    @Override
    public int getArity() {
        return 2;
    }
}

