/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.binary;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.BinaryVariable;

public class BitFlip
implements Variation {
    private final double probability;

    public BitFlip(double probability) {
        this.probability = probability;
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result = parents[0].copy();
        for (int i = 0; i < result.getNumberOfVariables(); ++i) {
            Variable variable = result.getVariable(i);
            if (!(variable instanceof BinaryVariable)) continue;
            BitFlip.evolve((BinaryVariable)variable, this.probability);
        }
        return new Solution[]{result};
    }

    public static void evolve(BinaryVariable variable, double probability) {
        for (int i = 0; i < variable.getNumberOfBits(); ++i) {
            if (!(PRNG.nextDouble() <= probability)) continue;
            variable.set(i, !variable.get(i));
        }
    }

    @Override
    public int getArity() {
        return 1;
    }
}

