/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.grammar;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.Grammar;

public class GrammarCrossover
implements Variation {
    private final double probability;

    public GrammarCrossover(double probability) {
        this.probability = probability;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result1 = parents[0].copy();
        Solution result2 = parents[1].copy();
        for (int i = 0; i < result1.getNumberOfVariables(); ++i) {
            Variable variable1 = result1.getVariable(i);
            Variable variable2 = result2.getVariable(i);
            if (!(PRNG.nextDouble() <= this.probability) || !(variable1 instanceof Grammar) || !(variable2 instanceof Grammar)) continue;
            GrammarCrossover.evolve((Grammar)variable1, (Grammar)variable2);
        }
        return new Solution[]{result1, result2};
    }

    public static void evolve(Grammar g1, Grammar g2) {
        int pos1 = PRNG.nextInt(g1.size() - 1) + 1;
        int pos2 = PRNG.nextInt(g2.size() - 1) + 1;
        int[] removed1 = g1.cut(pos1, g1.size() - 1);
        int[] removed2 = g2.cut(pos2, g2.size() - 1);
        g1.insert(pos1, removed2);
        g2.insert(pos2, removed1);
    }

    @Override
    public int getArity() {
        return 2;
    }
}

