/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.permutation;

import java.util.Arrays;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.Permutation;

public class PMX
implements Variation {
    private final double probability;

    public PMX(double probability) {
        this.probability = probability;
    }

    public static void evolve(Permutation p1, Permutation p2) {
        int i;
        int cuttingPoint2;
        int n = p1.size();
        if (n != p2.size()) {
            throw new FrameworkException("permutations not same size");
        }
        int cuttingPoint1 = PRNG.nextInt(n);
        if (cuttingPoint1 == (cuttingPoint2 = PRNG.nextInt(n - 1))) {
            cuttingPoint2 = n - 1;
        } else if (cuttingPoint1 > cuttingPoint2) {
            int swap = cuttingPoint1;
            cuttingPoint1 = cuttingPoint2;
            cuttingPoint2 = swap;
        }
        int[] parent1 = p1.toArray();
        int[] parent2 = p2.toArray();
        int[] offspring1 = new int[n];
        int[] offspring2 = new int[n];
        int[] replacement1 = new int[n];
        int[] replacement2 = new int[n];
        Arrays.fill(replacement1, -1);
        Arrays.fill(replacement2, -1);
        for (i = cuttingPoint1; i <= cuttingPoint2; ++i) {
            offspring1[i] = parent2[i];
            offspring2[i] = parent1[i];
            replacement1[parent2[i]] = parent1[i];
            replacement2[parent1[i]] = parent2[i];
        }
        for (i = 0; i < n; ++i) {
            if (i >= cuttingPoint1 && i <= cuttingPoint2) continue;
            int n1 = parent1[i];
            int m1 = replacement1[n1];
            int n2 = parent2[i];
            int m2 = replacement2[n2];
            while (m1 != -1) {
                n1 = m1;
                m1 = replacement1[m1];
            }
            while (m2 != -1) {
                n2 = m2;
                m2 = replacement2[m2];
            }
            offspring1[i] = n1;
            offspring2[i] = n2;
        }
        p1.fromArray(offspring1);
        p2.fromArray(offspring2);
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result1 = parents[0].copy();
        Solution result2 = parents[1].copy();
        for (int i = 0; i < result1.getNumberOfVariables(); ++i) {
            Variable variable1 = result1.getVariable(i);
            Variable variable2 = result2.getVariable(i);
            if (!(PRNG.nextDouble() <= this.probability) || !(variable1 instanceof Permutation) || !(variable2 instanceof Permutation)) continue;
            PMX.evolve((Permutation)variable1, (Permutation)variable2);
        }
        return new Solution[]{result1, result2};
    }

    @Override
    public int getArity() {
        return 2;
    }
}

