/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.permutation;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.Permutation;

public class Swap
implements Variation {
    private final double probability;

    public Swap(double probability) {
        this.probability = probability;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result = parents[0].copy();
        for (int i = 0; i < result.getNumberOfVariables(); ++i) {
            Variable variable = result.getVariable(i);
            if (!(PRNG.nextDouble() <= this.probability) || !(variable instanceof Permutation)) continue;
            Swap.evolve((Permutation)variable);
        }
        return new Solution[]{result};
    }

    public static void evolve(Permutation permutation) {
        int j;
        int i = PRNG.nextInt(permutation.size());
        if (i == (j = PRNG.nextInt(permutation.size() - 1))) {
            j = permutation.size() - 1;
        }
        permutation.swap(i, j);
    }

    @Override
    public int getArity() {
        return 1;
    }
}

