/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.program;

import java.util.List;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.Program;
import org.moeaframework.util.tree.Node;
import org.moeaframework.util.tree.Rules;

public class PointMutation
implements Variation {
    private double probability;

    public PointMutation(double probability) {
        this.probability = probability;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result = parents[0].copy();
        for (int i = 0; i < result.getNumberOfVariables(); ++i) {
            Variable variable = result.getVariable(i);
            if (!(variable instanceof Program)) continue;
            Program program = (Program)variable;
            this.mutate(program.getArgument(0), program.getRules());
        }
        return new Solution[]{result};
    }

    protected void mutate(Node node, Rules rules) {
        List<Node> mutations;
        if (!node.isFixed() && PRNG.nextDouble() <= this.probability && !(mutations = rules.listAvailableMutations(node)).isEmpty()) {
            int i;
            Node mutation = PRNG.nextItem(mutations).copyNode();
            Node parent = node.getParent();
            for (i = 0; i < parent.getNumberOfArguments(); ++i) {
                if (parent.getArgument(i) != node) continue;
                parent.setArgument(i, mutation);
                break;
            }
            for (i = 0; i < node.getNumberOfArguments(); ++i) {
                mutation.setArgument(i, node.getArgument(i));
            }
            node = mutation;
        }
        for (int i = 0; i < node.getNumberOfArguments(); ++i) {
            this.mutate(node.getArgument(i), rules);
        }
    }
}

