/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.program;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.Program;
import org.moeaframework.util.tree.Node;
import org.moeaframework.util.tree.Rules;

public class SubtreeCrossover
implements Variation {
    private double probability;

    public SubtreeCrossover(double probability) {
        this.probability = probability;
    }

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result1 = parents[0].copy();
        Solution result2 = parents[1].copy();
        for (int i = 0; i < result1.getNumberOfVariables(); ++i) {
            Variable variable1 = result1.getVariable(i);
            Variable variable2 = result2.getVariable(i);
            if (!(PRNG.nextDouble() <= this.probability) || !(variable1 instanceof Program) || !(variable2 instanceof Program)) continue;
            Program program1 = (Program)variable1;
            Program program2 = (Program)variable2;
            this.crossover(program1, program2, program1.getRules());
        }
        return new Solution[]{result1};
    }

    protected void crossover(Program program1, Program program2, Rules rules) {
        int size;
        Node node = null;
        Node replacement = null;
        if (PRNG.nextDouble() <= rules.getFunctionCrossoverProbability()) {
            size = program1.getArgument(0).getNumberOfFunctions();
            if (size == 0) {
                return;
            }
            node = program1.getArgument(0).getFunctionAt(PRNG.nextInt(size));
        } else {
            size = program1.getArgument(0).getNumberOfTerminals();
            if (size == 0) {
                return;
            }
            node = program1.getArgument(0).getTerminalAt(PRNG.nextInt(size));
        }
        if (PRNG.nextDouble() <= rules.getFunctionCrossoverProbability()) {
            size = program2.getArgument(0).getNumberOfFunctions(node.getReturnType());
            if (size == 0) {
                return;
            }
            replacement = program2.getArgument(0).getFunctionAt(node.getReturnType(), PRNG.nextInt(size));
        } else {
            size = program2.getArgument(0).getNumberOfTerminals(node.getReturnType());
            if (size == 0) {
                return;
            }
            replacement = program2.getArgument(0).getTerminalAt(node.getReturnType(), PRNG.nextInt(size));
        }
        if (node.isFixed() || replacement.isFixed()) {
            return;
        }
        if (node.getDepth() + replacement.getMaximumHeight() > rules.getMaxVariationDepth()) {
            return;
        }
        Node parent = node.getParent();
        for (int i = 0; i < parent.getNumberOfArguments(); ++i) {
            if (parent.getArgument(i) != node) continue;
            parent.setArgument(i, replacement);
            break;
        }
    }
}

