/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.real;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;

public class AdaptiveMetropolis
implements Variation {
    private final int numberOfParents;
    private final int numberOfOffspring;
    private final double jumpRateCoefficient;

    public AdaptiveMetropolis(int numberOfParents, int numberOfOffspring, double jumpRateCoefficient) {
        this.numberOfParents = numberOfParents;
        this.numberOfOffspring = numberOfOffspring;
        this.jumpRateCoefficient = jumpRateCoefficient;
    }

    @Override
    public int getArity() {
        return this.numberOfParents;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        int k = parents.length;
        int n = parents[0].getNumberOfVariables();
        Array2DRowRealMatrix x = new Array2DRowRealMatrix(k, n);
        for (int i = 0; i < k; ++i) {
            x.setRow(i, EncodingUtils.getReal(parents[i]));
        }
        try {
            double jumpRate = Math.pow(this.jumpRateCoefficient / Math.sqrt(n), 2.0);
            RealMatrix chol = new CholeskyDecomposition(new Covariance(x.scalarMultiply(jumpRate)).getCovarianceMatrix()).getLT();
            Solution[] offspring = new Solution[this.numberOfOffspring];
            for (int i = 0; i < this.numberOfOffspring; ++i) {
                Solution child = parents[PRNG.nextInt(parents.length)].copy();
                ArrayRealVector muC = new ArrayRealVector(EncodingUtils.getReal(child));
                ArrayRealVector ru = new ArrayRealVector(n);
                for (int j = 0; j < n; ++j) {
                    ru.setEntry(j, PRNG.nextGaussian());
                }
                double[] variables = muC.add(chol.preMultiply((RealVector)ru)).toArray();
                for (int j = 0; j < n; ++j) {
                    double value = variables[j];
                    RealVariable variable = (RealVariable)child.getVariable(j);
                    if (value < variable.getLowerBound()) {
                        value = variable.getLowerBound();
                    } else if (value > variable.getUpperBound()) {
                        value = variable.getUpperBound();
                    }
                    variable.setValue(value);
                }
                offspring[i] = child;
            }
            return offspring;
        }
        catch (Exception e) {
            return new Solution[0];
        }
    }
}

