/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.real;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.RealVariable;

public class DifferentialEvolution
implements Variation {
    private final double CR;
    private final double F;

    public DifferentialEvolution(double CR, double F) {
        this.CR = CR;
        this.F = F;
    }

    public double getCrossoverRate() {
        return this.CR;
    }

    public double getScalingFactor() {
        return this.F;
    }

    @Override
    public int getArity() {
        return 4;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result = parents[0].copy();
        int jrand = PRNG.nextInt(result.getNumberOfVariables());
        for (int j = 0; j < result.getNumberOfVariables(); ++j) {
            if (!(PRNG.nextDouble() <= this.CR) && j != jrand) continue;
            RealVariable v0 = (RealVariable)result.getVariable(j);
            RealVariable v1 = (RealVariable)parents[1].getVariable(j);
            RealVariable v2 = (RealVariable)parents[2].getVariable(j);
            RealVariable v3 = (RealVariable)parents[3].getVariable(j);
            double y = v3.getValue() + this.F * (v1.getValue() - v2.getValue());
            if (y < v0.getLowerBound()) {
                y = v0.getLowerBound();
            }
            if (y > v0.getUpperBound()) {
                y = v0.getUpperBound();
            }
            v0.setValue(y);
        }
        return new Solution[]{result};
    }
}

