/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.real;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;

public class DifferentialEvolutionSelection
implements Selection {
    private int currentIndex;

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    @Override
    public Solution[] select(int arity, Population population) {
        if (population.size() < arity) {
            throw new IllegalArgumentException("population too small");
        }
        int[] indices = new int[arity];
        indices[0] = this.currentIndex;
        for (int i = 1; i < arity; ++i) {
            boolean isDuplicate;
            block1: do {
                isDuplicate = false;
                indices[i] = PRNG.nextInt(population.size());
                for (int j = 0; j < i; ++j) {
                    if (indices[i] != indices[j]) continue;
                    isDuplicate = true;
                    continue block1;
                }
            } while (isDuplicate);
        }
        Solution[] result = new Solution[arity];
        for (int i = 0; i < arity; ++i) {
            result[i] = population.get(indices[i]);
        }
        return result;
    }
}

