/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.real;

import java.util.ArrayList;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.util.Vector;

public class PCX
implements Variation {
    private final int numberOfParents;
    private final int numberOfOffspring;
    private final double eta;
    private final double zeta;

    public PCX(int numberOfParents, int numberOfOffspring) {
        this(numberOfParents, numberOfOffspring, 0.1, 0.1);
    }

    public PCX(int numberOfParents, int numberOfOffspring, double eta, double zeta) {
        this.numberOfParents = numberOfParents;
        this.numberOfOffspring = numberOfOffspring;
        this.eta = eta;
        this.zeta = zeta;
    }

    public int getNumberOfParents() {
        return this.numberOfParents;
    }

    public int getNumberOfOffspring() {
        return this.numberOfOffspring;
    }

    public double getEta() {
        return this.eta;
    }

    public double getZeta() {
        return this.zeta;
    }

    @Override
    public int getArity() {
        return this.numberOfParents;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution[] result = new Solution[this.numberOfOffspring];
        parents = (Solution[])parents.clone();
        for (int i = 0; i < this.numberOfOffspring; ++i) {
            int index = PRNG.nextInt(parents.length);
            Solution temp = parents[index];
            parents[index] = parents[parents.length - 1];
            parents[parents.length - 1] = temp;
            result[i] = this.pcx(parents);
        }
        return result;
    }

    protected Solution pcx(Solution[] parents) {
        if (parents.length < 2) {
            throw new IllegalArgumentException("requires at least 2 parents");
        }
        int k = parents.length;
        int n = parents[0].getNumberOfVariables();
        double[][] x = new double[k][n];
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < n; ++j) {
                x[i][j] = ((RealVariable)parents[i].getVariable(j)).getValue();
            }
        }
        double[] g = Vector.mean(x);
        ArrayList<double[]> e_eta = new ArrayList<double[]>();
        e_eta.add(Vector.subtract(x[k - 1], g));
        double D = 0.0;
        for (int i = 0; i < k - 1; ++i) {
            double[] e;
            double[] d = Vector.subtract(x[i], g);
            if (Vector.isZero(d) || Vector.isZero(e = Vector.orthogonalize(d, e_eta))) continue;
            D += Vector.magnitude(e);
            e_eta.add(Vector.normalize(e));
        }
        D /= (double)(k - 1);
        double[] variables = x[k - 1];
        variables = Vector.add(variables, Vector.multiply(PRNG.nextGaussian(0.0, this.zeta), (double[])e_eta.get(0)));
        double eta = PRNG.nextGaussian(0.0, this.eta);
        for (int i = 1; i < e_eta.size(); ++i) {
            variables = Vector.add(variables, Vector.multiply(eta * D, (double[])e_eta.get(i)));
        }
        Solution result = parents[k - 1].copy();
        for (int j = 0; j < n; ++j) {
            double value = variables[j];
            RealVariable variable = (RealVariable)result.getVariable(j);
            if (value < variable.getLowerBound()) {
                value = variable.getLowerBound();
            } else if (value > variable.getUpperBound()) {
                value = variable.getUpperBound();
            }
            variable.setValue(value);
        }
        return result;
    }
}

