/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.real;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.RealVariable;

public class PM
implements Variation {
    private final double probability;
    private final double distributionIndex;

    public PM(double probability, double distributionIndex) {
        this.probability = probability;
        this.distributionIndex = distributionIndex;
    }

    public double getProbability() {
        return this.probability;
    }

    public double getDistributionIndex() {
        return this.distributionIndex;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result = parents[0].copy();
        for (int i = 0; i < result.getNumberOfVariables(); ++i) {
            Variable variable = result.getVariable(i);
            if (!(PRNG.nextDouble() <= this.probability) || !(variable instanceof RealVariable)) continue;
            PM.evolve((RealVariable)variable, this.distributionIndex);
        }
        return new Solution[]{result};
    }

    public static void evolve(RealVariable v, double distributionIndex) {
        double delta;
        double u = PRNG.nextDouble();
        double x = v.getValue();
        double lb = v.getLowerBound();
        double ub = v.getUpperBound();
        double dx = ub - lb;
        if (u < 0.5) {
            double bl = (x - lb) / dx;
            double b = 2.0 * u + (1.0 - 2.0 * u) * Math.pow(1.0 - bl, distributionIndex + 1.0);
            delta = Math.pow(b, 1.0 / (distributionIndex + 1.0)) - 1.0;
        } else {
            double bu = (ub - x) / dx;
            double b = 2.0 * (1.0 - u) + 2.0 * (u - 0.5) * Math.pow(1.0 - bu, distributionIndex + 1.0);
            delta = 1.0 - Math.pow(b, 1.0 / (distributionIndex + 1.0));
        }
        x += delta * dx;
        if (x < lb) {
            x = lb;
        } else if (x > ub) {
            x = ub;
        }
        v.setValue(x);
    }

    @Override
    public int getArity() {
        return 1;
    }
}

