/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.real;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.RealVariable;

public class SPX
implements Variation {
    private final int numberOfParents;
    private final int numberOfOffspring;
    private final double epsilon;

    public SPX(int numberOfParents, int numberOfOffspring) {
        this(numberOfParents, numberOfOffspring, Math.sqrt(numberOfParents + 1));
    }

    public SPX(int numberOfParents, int numberOfOffspring, double epsilon) {
        this.numberOfParents = numberOfParents;
        this.numberOfOffspring = numberOfOffspring;
        this.epsilon = epsilon;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        int j;
        int i;
        int n = parents.length;
        int m = parents[0].getNumberOfVariables();
        double[] G = new double[m];
        double[][] x = new double[n][m];
        double[] r = new double[n - 1];
        double[][] C = new double[n][m];
        Solution[] offspring = new Solution[this.numberOfOffspring];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                int n2 = j;
                G[n2] = G[n2] + ((RealVariable)parents[i].getVariable(j)).getValue();
            }
        }
        int j2 = 0;
        while (j2 < m) {
            int n3 = j2++;
            G[n3] = G[n3] / (double)n;
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                x[i][j] = G[j] + this.epsilon * (((RealVariable)parents[i].getVariable(j)).getValue() - G[j]);
            }
        }
        for (int k = 0; k < this.numberOfOffspring; ++k) {
            int i2;
            Solution child = parents[n - 1].copy();
            for (i2 = 0; i2 < n - 1; ++i2) {
                r[i2] = Math.pow(PRNG.nextDouble(), 1.0 / ((double)i2 + 1.0));
            }
            for (i2 = 0; i2 < n; ++i2) {
                for (int j3 = 0; j3 < m; ++j3) {
                    C[i2][j3] = i2 == 0 ? 0.0 : r[i2 - 1] * (x[i2 - 1][j3] - x[i2][j3] + C[i2 - 1][j3]);
                }
            }
            for (int j4 = 0; j4 < m; ++j4) {
                double value = x[n - 1][j4] + C[n - 1][j4];
                RealVariable variable = (RealVariable)child.getVariable(j4);
                if (value < variable.getLowerBound()) {
                    value = variable.getLowerBound();
                } else if (value > variable.getUpperBound()) {
                    value = variable.getUpperBound();
                }
                variable.setValue(value);
            }
            offspring[k] = child;
        }
        return offspring;
    }

    @Override
    public int getArity() {
        return this.numberOfParents;
    }

    public int getNumberOfParents() {
        return this.numberOfParents;
    }

    public int getNumberOfOffspring() {
        return this.numberOfOffspring;
    }

    public double getEpsilon() {
        return this.epsilon;
    }
}

