/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.real;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.RealVariable;

public class UM
implements Variation {
    private final double probability;

    public UM(double probability) {
        this.probability = probability;
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result = parents[0].copy();
        for (int i = 0; i < result.getNumberOfVariables(); ++i) {
            Variable variable = result.getVariable(i);
            if (!(PRNG.nextDouble() <= this.probability) || !(variable instanceof RealVariable)) continue;
            UM.evolve((RealVariable)variable);
        }
        return new Solution[]{result};
    }

    public static void evolve(RealVariable variable) {
        variable.setValue(PRNG.nextDouble(variable.getLowerBound(), variable.getUpperBound()));
    }

    @Override
    public int getArity() {
        return 1;
    }
}

