/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.real;

import java.util.ArrayList;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.util.Vector;

public class UNDX
implements Variation {
    private final int numberOfParents;
    private final int numberOfOffspring;
    private final double zeta;
    private final double eta;

    public UNDX(int numberOfParents, int numberOfOffspring) {
        this(numberOfParents, numberOfOffspring, 0.5, 0.35);
    }

    public UNDX(int numberOfParents, int numberOfOffspring, double zeta, double eta) {
        this.numberOfParents = numberOfParents;
        this.numberOfOffspring = numberOfOffspring;
        this.zeta = zeta;
        this.eta = eta;
    }

    public int getNumberOfParents() {
        return this.numberOfParents;
    }

    public int getNumberOfOffspring() {
        return this.numberOfOffspring;
    }

    public double getZeta() {
        return this.zeta;
    }

    public double getEta() {
        return this.eta;
    }

    @Override
    public int getArity() {
        return this.numberOfParents;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution[] result = new Solution[this.numberOfOffspring];
        for (int i = 0; i < this.numberOfOffspring; ++i) {
            result[i] = this.undx(parents);
        }
        return result;
    }

    private double[] randomVector(int n) {
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = PRNG.nextGaussian();
        }
        return v;
    }

    public Solution undx(Solution[] parents) {
        int i;
        double[] e;
        if (parents.length < 2) {
            throw new IllegalArgumentException("requires at least 2 parents");
        }
        int k = parents.length;
        int n = parents[0].getNumberOfVariables();
        double[][] x = new double[k][n];
        for (int i2 = 0; i2 < k; ++i2) {
            for (int j = 0; j < n; ++j) {
                x[i2][j] = ((RealVariable)parents[i2].getVariable(j)).getValue();
            }
        }
        double[] g = Vector.mean(x);
        ArrayList<double[]> e_zeta = new ArrayList<double[]>();
        ArrayList<double[]> e_eta = new ArrayList<double[]>();
        for (int i3 = 0; i3 < k - 1; ++i3) {
            double[] d = Vector.subtract(x[i3], g);
            if (Vector.isZero(d)) continue;
            double dbar = Vector.magnitude(d);
            e = Vector.orthogonalize(d, e_zeta);
            if (Vector.isZero(e)) continue;
            e_zeta.add(Vector.multiply(dbar, Vector.normalize(e)));
        }
        double D = Vector.magnitude(Vector.subtract(x[k - 1], g));
        for (int i4 = 0; i4 < n - e_zeta.size(); ++i4) {
            double[] d = this.randomVector(n);
            if (Vector.isZero(d) || Vector.isZero(e = Vector.orthogonalize(d, e_eta))) continue;
            e_eta.add(Vector.multiply(D, Vector.normalize(e)));
        }
        double[] variables = g;
        for (i = 0; i < e_zeta.size(); ++i) {
            variables = Vector.add(variables, Vector.multiply(PRNG.nextGaussian(0.0, this.zeta), (double[])e_zeta.get(i)));
        }
        for (i = 0; i < e_eta.size(); ++i) {
            variables = Vector.add(variables, Vector.multiply(PRNG.nextGaussian(0.0, this.eta / Math.sqrt(n)), (double[])e_eta.get(i)));
        }
        Solution result = parents[k - 1].copy();
        for (int j = 0; j < n; ++j) {
            double value = variables[j];
            RealVariable variable = (RealVariable)result.getVariable(j);
            if (value < variable.getLowerBound()) {
                value = variable.getLowerBound();
            } else if (value > variable.getUpperBound()) {
                value = variable.getUpperBound();
            }
            variable.setValue(value);
        }
        return result;
    }
}

