/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.subset;

import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.Subset;

public class Replace
implements Variation {
    private final double probability;

    public Replace(double probability) {
        this.probability = probability;
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result = parents[0].copy();
        for (int i = 0; i < result.getNumberOfVariables(); ++i) {
            Variable variable = result.getVariable(i);
            if (!(PRNG.nextDouble() <= this.probability) || !(variable instanceof Subset)) continue;
            Replace.evolve((Subset)variable);
        }
        return new Solution[]{result};
    }

    public static void evolve(Subset subset) {
        if (subset.getK() < subset.getN()) {
            int i = PRNG.nextInt(subset.getK());
            subset.set(i, subset.randomNonmember());
        }
    }

    @Override
    public int getArity() {
        return 1;
    }
}

