/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.operator.subset;

import java.util.Set;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.variable.Subset;

public class SSX
implements Variation {
    private final double probability;

    public SSX(double probability) {
        this.probability = probability;
    }

    public static void evolve(Subset s1, Subset s2) {
        int k = s1.getK();
        Set<Integer> p1set = s1.getSet();
        Set<Integer> p2set = s2.getSet();
        for (int i = 0; i < k; ++i) {
            if (p1set.contains(s2.get(i)) || p2set.contains(s1.get(i)) || !PRNG.nextBoolean()) continue;
            int temp = s1.get(i);
            s1.set(i, s2.get(i));
            s2.set(i, temp);
        }
    }

    @Override
    public Solution[] evolve(Solution[] parents) {
        Solution result1 = parents[0].copy();
        Solution result2 = parents[1].copy();
        for (int i = 0; i < result1.getNumberOfVariables(); ++i) {
            Variable variable1 = result1.getVariable(i);
            Variable variable2 = result2.getVariable(i);
            if (!(PRNG.nextDouble() <= this.probability) || !(variable1 instanceof Subset) || !(variable2 instanceof Subset)) continue;
            SSX.evolve((Subset)variable1, (Subset)variable2);
        }
        return new Solution[]{result1, result2};
    }

    @Override
    public int getArity() {
        return 2;
    }
}

