/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.core.spi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.moeaframework.algorithm.StandardAlgorithms;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.Problem;
import org.moeaframework.core.spi.AlgorithmProvider;
import org.moeaframework.core.spi.ProviderNotFoundException;

public class AlgorithmFactory {
    private static final ServiceLoader<AlgorithmProvider> PROVIDERS = ServiceLoader.load(AlgorithmProvider.class);
    private static AlgorithmFactory instance = new AlgorithmFactory();
    private List<AlgorithmProvider> customProviders = new ArrayList<AlgorithmProvider>();

    public static synchronized AlgorithmFactory getInstance() {
        return instance;
    }

    public static synchronized void setInstance(AlgorithmFactory instance) {
        AlgorithmFactory.instance = instance;
    }

    public void addProvider(AlgorithmProvider provider) {
        this.customProviders.add(provider);
    }

    public synchronized Algorithm getAlgorithm(String name, Properties properties, Problem problem) {
        Algorithm algorithm;
        Algorithm algorithm2;
        boolean hasStandardAlgorithms = false;
        for (AlgorithmProvider provider : this.customProviders) {
            algorithm2 = this.instantiateAlgorithm(provider, name, properties, problem);
            if (provider.getClass() == StandardAlgorithms.class) {
                hasStandardAlgorithms = true;
            }
            if (algorithm2 == null) continue;
            return algorithm2;
        }
        for (AlgorithmProvider provider : PROVIDERS) {
            algorithm2 = this.instantiateAlgorithm(provider, name, properties, problem);
            if (provider.getClass() == StandardAlgorithms.class) {
                hasStandardAlgorithms = true;
            }
            if (algorithm2 == null) continue;
            return algorithm2;
        }
        if (!hasStandardAlgorithms && (algorithm = this.instantiateAlgorithm(new StandardAlgorithms(), name, properties, problem)) != null) {
            return algorithm;
        }
        throw new ProviderNotFoundException(name);
    }

    private Algorithm instantiateAlgorithm(AlgorithmProvider provider, String name, Properties properties, Problem problem) {
        try {
            return provider.getAlgorithm(name, properties, problem);
        }
        catch (ServiceConfigurationError e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
}

